<?php

namespace CSSTidy\Optimise;

use CSSTidy\Logger;
use CSSTidy\Element;;

class LineAt
{
    /** @var \CSSTidy\Logger */
    protected $logger;

    public function __construct(
        Logger $logger
    ) {
        $this->logger = $logger;
    }

    /**
     * Remove url() and first space if is not required from LineAt
     * @param \CSSTidy\LineAt $lineAt
     */
    public function process(Element\LineAt $lineAt)
    {
        $value = $lineAt->getValue();
        $value = $this->removeUrl($value);

        // Remove first space if first token is string
        if (isset($value{1}) && ($value{1} === '"' || $value{1} === '\'')) {
            $value = substr($value, 1);
        }

        $lineAt->setValue($value);
    }

    /**
     * Replace url('abc.css') with "abc.css"
     * @param string $string
     * @return string
     */
    protected function removeUrl($string)
    {
        return preg_replace('~url\(["\']?([^\)\'" ]*)["\']?[ ]?\)~', '"$1"', $string);
    }
}