<?php
/*
mimetypes.php -  Exension to MIME-Type mapping, pretty much the same as mime.types from Apache
Copyright (C) 2002, 2003, 2004 Stephen Lawrence Jr., Khoa Nguyen
Copyright (C) 2007 Stephen Lawrence Jr., Jon Miner
Copyright (C) 2008-2011 Stephen Lawrence Jr.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// Read default MIME Types from System
global $mimetypes;
$mimetypes = array(
'323' => array('text/h323'),
'7z' => array('application/x-7z-compressed'),
'abw' => array('application/x-abiword'),
'acx' => array('application/internet-property-stream'),
'ai' => array('application/postscript'),
'aif' => array('audio/x-aiff'),
'aifc' => array('audio/x-aiff'),
'aiff' => array('audio/x-aiff'),
'amf' => array('application/x-amf'),
'asf' => array('video/x-ms-asf'),
'asr' => array('video/x-ms-asf'),
'asx' => array('video/x-ms-asf'),
'atom' => array('application/atom+xml'),
'au' => array('audio/basic'),
'avi' => array('video/avi', 'video/msvideo', 'video/x-msvideo'),
'bcpio' => array('application/x-bcpio'),
'bin' => array('application/octet-stream','application/macbinary'),
'bmp' => array('image/bmp'),
'book' => array('application/x-maker'),
'bz2' => array('application/x-bzip2'),
'c' => array('text/x-csrc'),
'c++' => array('text/x-c++src'),
'cab' => array('application/x-cab'),
'cc' => array('text/x-c++src'),
'cda' => array('application/x-cdf'),
'cdf' => array('application/x-netcdf'),
'chrt' => array('application/x-kchart'),
'class' => array('application/octet-stream'),
'com' => array('application/x-msdos-program'),
'cpio' => array('application/x-cpio'),
'cpp' => array('text/x-c++src'),
'cpt' => array('application/mac-compactpro'),
'csh' => array('text/x-csh', 'application/x-csh'),
'css' => array('text/css'),
'csv' => array('text/x-comma-separated-values', 'application/vnd.ms-excel', 'text/comma-separated-values', 'text/csv'),
'dbk' => array('application/docbook+xml'),
'dcr' => array('application/x-director'),
'deb' => array('application/x-debian-package'),
'diff' => array('text/x-diff'),
'dir' => array('application/x-director'),
'divx' => array('video/divx'),
'djv' => array('image/vnd.djvu'),
'djvu' => array('image/vnd.djvu'),
'dl' => array('video/dl'),
'dll' => array('application/octet-stream', 'application/x-msdos-program'),
'dmg' => array('application/x-apple-diskimage'),
'dms' => array('application/octet-stream'),
'doc' => array('application/msword'),
'docm' => array('application/vnd.ms-word.document.macroEnabled.12'),
'docx' => array('application/vnd.openxmlformats-officedocument.wordprocessingml.document'),
'dot' => array('application/msword'),
'dotm' => array('application/vnd.ms-word.template.macroEnabled.12'),
'dotx' => array('application/vnd.openxmlformats-officedocument.wordprocessingml.template'),
'dtd' => array('text/xml'),
'dvi' => array('application/x-dvi'),
'dxr' => array('application/x-director'),
'eml' => array('message/rfc822'),
'eps' => array('application/postscript'),
'etx' => array('text/x-setext'),
'evy' => array('application/envoy'),
'exe' => array('application/x-msdos-program', 'application/octet-stream'),
'ez' => array('application/andrew-inset'),
'fb' => array('application/x-maker'),
'fbdoc' => array('application/x-maker'),
'fla' => array('application/octet-stream'),
'flac' => array('application/x-flac'),
'flc' => array('video/flc'),
'fli' => array('video/fli'),
'flv' => array('video/x-flv'),
'fm' => array('application/x-maker'),
'frame' => array('application/x-maker'),
'frm' => array('application/x-maker'),
'gif' => array('image/gif'),
'gl' => array('video/gl'),
'gtar' => array('application/x-gtar'),
'gz' => array('application/x-gzip'),
'h' => array('text/x-chdr'),
'h++' => array('text/x-c++hdr'),
'hdf' => array('application/x-hdf'),
'hh' => array('text/x-c++hdr'),
'hpp' => array('text/x-c++hdr'),
'hqx' => array('application/mac-binhex40'),
'hs' => array('text/x-haskell'),
'htm' => array('text/html'),
'html' => array('text/html'),
'ice' => array('x-conference/x-cooltalk'),
'ico' => array('image/x-icon'),
'ics' => array('text/calendar'),
'ief' => array('image/ief'),
'iges' => array('model/iges'),
'igs' => array('model/iges'),
'iii' => array('application/x-iphone'),
'ins' => array('application/x-internet-signup'),
'iso' => array('application/x-iso9660-image'),
'isp' => array('application/x-internet-signup'),
'jad' => array('text/vnd.sun.j2me.app-descriptor'),
'jar' => array('application/java-archive'),
'java' => array('application/x-java-applet'),
'jnlp' => array('application/x-java-jnlp-file'),
'jpe' => array('image/jpeg', 'image/pjpeg'),
'jpeg' => array('image/jpeg', 'image/pjpeg'),
'jpg' => array('image/jpeg', 'image/pjpeg'),
'js' => array('application/javascript'),
'json' => array('application/json'),
'kar' => array('audio/midi'),
'kil' => array('application/x-killustrator'),
'kpr' => array('application/x-kpresenter'),
'kpt' => array('application/x-kpresenter'),
'ksp' => array('application/x-kspread'),
'kwd' => array('application/x-kword'),
'kwt' => array('application/x-kword'),
'latex' => array('application/x-latex'),
'lha' => array('application/octet-stream'),
'log' => array('text/plain', 'text/x-log'),
'lzh' => array('application/octet-stream'),
'm3u' => array('audio/x-mpegurl'),
'm4a' => array('audio/mpeg'),
'm4p' => array('video/mp4v-es'),
'm4v' => array('video/mp4'),
'maker' => array('application/x-maker'),
'man' => array('application/x-troff-man'),
'mdb' => array('application/x-msaccess'),
'me' => array('application/x-troff-me'),
'mesh' => array('model/mesh'),
'mid' => array('audio/midi'),
'midi' => array('audio/midi'),
'mif' => array('application/vnd.mif'),
'mka' => array('audio/x-matroska'),
'mkv' => array('video/x-matroska'),
'mov' => array('video/quicktime'),
'movie' => array('video/x-sgi-movie'),
'mp2' => array('audio/mpeg'),
'mp3' => array('audio/mpeg'),
'mp4' => array('application/mp4','audio/mp4','video/mp4'),
'mpa' => array('video/mpeg'),
'mpe' => array('video/mpeg'),
'mpeg' => array('video/mpeg'),
'mpg' => array('video/mpeg'),
'mpg4' => array('video/mp4'),
'mpga' => array('audio/mpeg'),
'mpp' => array('application/vnd.ms-project'),
'mpv' => array('video/x-matroska'),
'mpv2' => array('video/mpeg'),
'ms' => array('application/x-troff-ms'),
'msg' => array('application/msoutlook','application/x-msg'),
'msh' => array('model/mesh'),
'msi' => array('application/x-msi'),
'mxu' => array('video/vnd.mpegurl'),
'nc' => array('application/x-netcdf'),
'nws' => array('message/rfc822'),
'oda' => array('application/oda'),
'odb' => array('application/vnd.oasis.opendocument.database'),
'odc' => array('application/vnd.oasis.opendocument.chart'),
'odf' => array('application/vnd.oasis.opendocument.forumla'),
'odg' => array('application/vnd.oasis.opendocument.graphics'),
'odi' => array('application/vnd.oasis.opendocument.image'),
'odm' => array('application/vnd.oasis.opendocument.text-master'),
'odp' => array('application/vnd.oasis.opendocument.presentation'),
'ods' => array('application/vnd.oasis.opendocument.spreadsheet'),
'odt' => array('application/vnd.oasis.opendocument.text'),
'oga' => array('audio/ogg'),
'ogg' => array('application/ogg'),
'ogv' => array('video/ogg'),
'otg' => array('application/vnd.oasis.opendocument.graphics-template'),
'oth' => array('application/vnd.oasis.opendocument.web'),
'otp' => array('application/vnd.oasis.opendocument.presentation-template'),
'ots' => array('application/vnd.oasis.opendocument.spreadsheet-template'),
'ott' => array('application/vnd.oasis.opendocument.template'),
'p' => array('text/x-pascal'),
'pac' => array('application/x-ns-proxy-autoconfig'),
'pas' => array('text/x-pascal'),
'patch' => array('text/x-diff'),
'pbm' => array('image/x-portable-bitmap'),
'pdb' => array('chemical/x-pdb'),
'pdf' => array('application/pdf', 'application/x-download'),
'pgm' => array('image/x-portable-graymap'),
'pgn' => array('application/x-chess-pgn'),
'pgp' => array('application/pgp'),
'php' => array('application/x-httpd-php'),
'php3' => array('application/x-httpd-php'),
'php4' => array('application/x-httpd-php'),
'php5' => array('application/x-httpd-php'),
'phps' => array('application/x-httpd-php-source'),
'pht' => array('application/x-httpd-php'),
'phtml' => array('application/x-httpd-php'),
'pl' => array('text/x-perl'),
'pm' => array('text/x-perl'),
'png' => array('image/png', 'image/x-png'),
'pnm' => array('image/x-portable-anymap'),
'po' => array('text/x-gettext-translation'),
'pot' => array('application/vnd.ms-powerpoint'),
'potm' => array('application/vnd.ms-powerpoint.template.macroEnabled.12'),
'potx' => array('application/vnd.openxmlformats-officedocument.presentationml.template'),
'ppa' => array('application/vnd.ms-powerpoint'),
'ppam' => array('application/vnd.ms-powerpoint.addin.macroEnabled.12'),
'ppm' => array('image/x-portable-pixmap'),
'pps' => array('application/vnd.ms-powerpoint'),
'ppsm' => array('application/vnd.ms-powerpoint.slideshow.macroEnabled.12'),
'ppsx' => array('application/vnd.openxmlformats-officedocument.presentationml.slideshow'),
'ppt' => array('application/powerpoint', 'application/vnd.ms-powerpoint'),
'pptm' => array('application/vnd.ms-powerpoint.presentation.macroEnabled.12'),
'pptx' => array('application/vnd.openxmlformats-officedocument.presentationml.presentation'),
'ps' => array('application/postscript'),
'psd' => array('application/x-photoshop', 'image/x-photoshop'),
'pub' => array('application/x-mspublisher'),
'py' => array('text/x-python'),
'qdf' => array('application/octet-stream'),
'qt' => array('video/quicktime'),
'ra' => array('audio/x-realaudio'),
'ram' => array('audio/x-realaudio', 'audio/x-pn-realaudio'),
'rar' => array('application/rar'),
'ras' => array('image/x-cmu-raster'),
'rgb' => array('image/x-rgb'),
'rm' => array('audio/x-pn-realaudio'),
'roff' => array('application/x-troff'),
'rpm' => array('audio/x-pn-realaudio-plugin', 'application/x-redhat-package-manager'),
'rss' => array('application/rss+xml'),
'rtf' => array('text/rtf'),
'rtx' => array('text/richtext'),
'rv' => array('video/vnd.rn-realvideo'),
'sda' => array('application/vnd.stardivision.draw'),
'sdc' => array('application/vnd.stardivision.calc'),
'sdd' => array('application/vnd.stardivision.impress'),
'sdw' => array('application/vnd.stardivision.writer'),
'sea' => array('application/octet-stream'),
'sgl' => array('application/vnd.stardivision.writer-global'),
'sgm' => array('text/sgml'),
'sgml' => array('text/sgml'),
'sh' => array('text/x-sh'),
'shar' => array('application/x-shar'),
'shtml' => array('text/html'),
'silo' => array('model/mesh'),
'sis' => array('application/vnd.symbian.install'),
'sit' => array('application/x-stuffit'),
'skd' => array('application/x-koan'),
'skm' => array('application/x-koan'),
'skp' => array('application/x-koan'),
'skt' => array('application/x-koan'),
'smf' => array('application/vnd.stardivision.math'),
'smi' => array('application/smil'),
'smil' => array('application/smil'),
'snd' => array('audio/basic'),
'so' => array('application/octet-stream'),
'spl' => array('application/x-futuresplash'),
'src' => array('application/x-wais-source'),
'stc' => array('application/vnd.sun.xml.calc.template'),
'std' => array('application/vnd.sun.xml.draw.template'),
'sti' => array('application/vnd.sun.xml.impress.template'),
'stw' => array('application/vnd.sun.xml.writer.template'),
'sv4cpio' => array('application/x-sv4cpio'),
'sv4crc' => array('application/x-sv4crc'),
'svg' => array('image/svg+xml'),
'swf' => array('application/x-shockwave-flash'),
'sxc' => array('application/vnd.sun.xml.calc'),
'sxd' => array('application/vnd.sun.xml.draw'),
'sxg' => array('application/vnd.sun.xml.writer.global'),
'sxi' => array('application/vnd.sun.xml.impress'),
'sxm' => array('application/vnd.sun.xml.math'),
'sxw' => array('application/vnd.sun.xml.writer'),
't' => array('application/x-troff'),
'tar' => array('application/x-tar'),
'tcl' => array('text/x-tcl'),
'tex' => array('application/x-tex'),
'texi' => array('application/x-texinfo'),
'texinfo=' => array('application/x-texinfo'),
'text' => array('text/plain'),
'texti' => array('application/x-texinfo'),
'textinfo' => array('application/x-texinfo'),
'tgz' => array('application/x-tar', 'application/x-gzip'),
'tif' => array('image/tiff'),
'tiff' => array('image/tiff'),
'torrent' => array('application/x-bittorrent'),
'tr' => array('application/x-troff'),
'tsv' => array('text/tab-separated-values'),
'txt' => array('text/plain'),
'ustar' => array('application/x-ustar'),
'vcd' => array('application/x-cdlink'),
'vcf' => array('text/x-vCard'),
'vcs' => array('text/x-vCalendar'),
'vrml' => array('model/vrml'),
'wav' => array('audio/x-wav'),
'wax' => array('audio/x-ms-wax'),
'wbmp' => array('image/vnd.wap.wbmp'),
'wbxml' => array('application/wbxml', 'application/vnd.wap.wbxml'),
'webm' => array('video/webm'),
'wk' => array('application/x-123'),
'wm' => array('video/x-ms-wm'),
'wma' => array('audio/x-ms-wma'),
'wmd' => array('application/x-ms-wmd'),
'wml' => array('text/vnd.wap.wml'),
'wmlc' => array('application/wmlc', 'application/vnd.wap.wmlc'),
'wmls' => array('text/vnd.wap.wmlscript'),
'wmlsc' => array('application/vnd.wap.wmlscriptc'),
'wmv' => array('video/x-ms-wmv', 'application/octet-stream'),
'wmx' => array('video/x-ms-wmx'),
'wmz' => array('application/x-ms-wmz'),
'word' => array('application/msword', 'application/octet-stream'),
'wp5' => array('application/wordperfect5.1'),
'wpd' => array('application/vnd.wordperfect'),
'wrd' => array('application/msword'),
'wrl' => array('model/vrml'),
'wvx' => array('video/x-ms-wvx'),
'wz' => array('application/x-Wingz'),
'xbm' => array('image/x-xbitmap'),
'xcf' => array('image/xcf'),
'xht' => array('application/xhtml+xml'),
'xhtml' => array('application/xhtml+xml'),
'xl' => array('application/excel', 'application/vnd.ms-excel'),
'xla' => array('application/excel', 'application/vnd.ms-excel'),
'xlc' => array('application/excel', 'application/vnd.ms-excel'),
'xlm' => array('application/excel', 'application/vnd.ms-excel'),
'xls' => array('application/excel', 'application/vnd.ms-excel'),
'xlsx' => array('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'),
'xlt' => array('application/excel', 'application/vnd.ms-excel'),
'xml' => array('text/xml', 'application/xml'),
'xof' => array('x-world/x-vrml'),
'xpm' => array('image/x-xpixmap'),
'xsl' => array('text/xml'),
'xvid' => array('video/x-xvid'),
'xwd' => array('image/x-xwindowdump'),
'z' => array('application/x-compress'),
'zip' => array('application/x-zip', 'application/zip', 'application/x-zip-compressed'),
'default' => array('')
    );