<?php
/**
 phpSQLiteAdmin is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 phpSQLiteAdmin is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with phpSQLiteAdmin; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
 Copyright 2004 Richard Heyes
 Copyright 2006-2009 Marius Stanciu <marius.stanciu@code-purity.com>
 */

/**
 * Main phpSQLiteAdmin configuration file
 *
 * @package		phpSQLiteAdmin
 * @author		Marius Stanciu Sergiu <marius.stanciu@code-purity.com>
 * @copyright		Copyright (c) 2006-2009, Code Purity www.code-purity.com
 * @link		http://blog.code-purity.com/pages/phpsqliteadmin
 * @since		Version 0.1.0
 */
$config['version'] = "2.0.0";
$config['base_dir'] = dirname(__FILE__).DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR;

// Authentication method and parameters
$config['authentication']['enabled'] = false;
$config['authentication']['type'] = config;
$config['authentication']['users']['user'][0]['username'] = 'admin';
$config['authentication']['users']['user'][0]['password'] = 'password';
$config['authentication']['database'] = 'config/auth.db';
$config['authentication']['username_column'] = 'username';
$config['authentication']['password_column'] = 'password';

// first SQLite database
$config['databases']['database'][0]['path'] = 'sqlite.db';
$config['databases']['database'][0]['name'] = 'First database';
$config['databases']['database'][0]['desc'] = 'This is a test database';
// second SQLite database
// $config['databases']['database'][1]['path'] = 'anotherdb';
// $config['databases']['database'][1]['name'] = 'Second database';

$config['http_compression'] = true;

// Default language
$config['languages']['default'] = 'en';
$config['languages']['language'][0]['label'] = 'English';
$config['languages']['language'][0]['code'] = 'en';
?>