<?php

/**
 phpSQLiteAdmin is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 phpSQLiteAdmin is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with phpSQLiteAdmin; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
 Copyright 2004 Richard Heyes
 Copyright 2006-2009 Marius Stanciu <marius.stanciu@code-purity.com>
 */

/**
 * Enter description here...
 *
 * @package		phpSQLiteAdmin
 * @subpackage		Core
 * @author		Marius Stanciu Sergiu <marius.stanciu@code-purity.com>
 * @copyright		Copyright (c) 2006-2009, Code Purity www.code-purity.com
 * @link		http://blog.code-purity.com/pages/phpsqliteadmin
 * @since		Version 0.1.0
 */

class authentication
{
/**
 * Enter description here...
 *
 * @return unknown
 */
    function &factory()
    {
	global $config, $logger;
	$auth_settings = $config['authentication'];
	if (!empty($auth_settings['type']))
	{
	    $driver_path = $config['base_dir'].'include/auth/'.$auth_settings['type'].'.php';
	    if (file_exists($driver_path))
	    {
		include_once($driver_path);
		$driver_object = "authentication_$auth_settings[type]";
		return new $driver_object();
	    }
	    else
	    {
		$logger->log(common::lang("Error: Cannot find specified authentication driver ($auth_settings[type]"));
		return false;
	    }
	}
	else
	{
	    $logger->log(common::lang('Configuration error: No authentication type defined'));
	    return false;
	}
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function isLoggedIn()
    {
	global $config;
	$authEnabled = $config['authentication']['enabled'];
	if ($authEnabled == true)
	{
	    if (!empty($_SESSION['login']['authenticated']))
	    {
		return true;
	    }
	    else
	    {
		return false;
	    }
	}
	else
	{
	    return false;
	}
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $loginPage
     * @param unknown_type $redirect
     */
    function check($login_page, $redirect)
    {
	if (!authentication::isLoggedIn())
	{
	    $_SESSION['login']['redirect'] = $redirect;
	    common::redirect($login_page);
	}
    }
}
?>