<?php

/**
 phpSQLiteAdmin is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 phpSQLiteAdmin is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with phpSQLiteAdmin; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
 Copyright 2004 Richard Heyes
 Copyright 2006-2009 Marius Stanciu <marius.stanciu@code-purity.com>
 */

/**
 * Enter description here...
 *
 * @package		phpSQLiteAdmin
 * @subpackage		Core
 * @author		Marius Stanciu Sergiu <marius.stanciu@code-purity.com>
 * @copyright		Copyright (c) 2006-2009, Code Purity www.code-purity.com
 * @link		http://blog.code-purity.com/pages/phpsqliteadmin
 * @since		Version 0.1.0
 */

class common
{
    function generateMenu($tableName, $sel)
    {
	$sel1 = $sel2 = $sel3 = $sel4 = $sel5 = $sel6 = "default";
	if ($sel == 1)
	{
	    $sel1 = "selected";
	}
	else if ($sel == 2)
	{
	    $sel2 = "selected";
	}
	else if ($sel == 3)
	{
	    $sel3 = "selected";
	}
	else if ($sel == 4)
	{
	    $sel4 = "selected";
	}
	else if ($sel == 5)
	{
	    $sel5 = "selected";
	}
	else if ($sel == 6)
	{
	    $sel16 = "selected";
	}
	$out = '';
	$out .= '<div id="tabs">';
	$out .= '<ul>';
	$out .= '<li><a class="'.$sel1.'" href="'.common::url("index.php?do=11&table=".$tableName).'">'.common::lang('Browse').'</a></li>';
	$out .= '<li><a class="'.$sel2.'" href="'.common::url("index.php?do=2&table=".rawurlencode($tableName)).'">'.common::lang('Structure').'</a></li>';
	$out .= '<li><a class="'.$sel3.'" href="'.common::url("index.php?do=1&table=".rawurlencode($tableName)).'">'.common::lang('Query').'</a></li>';
	$out .= '<li><a class="'.$sel4.'" href="'.common::url("index.php?do=3&action=insert&table=".rawurlencode($tableName)."&redirect=".rawurlencode("index.php?do=2&table=$tableName")).'">'.common::lang('Insert').'</a></li>';
		$out .= '<li><a class="'.$sel5.'" href="'.common::url("index.php?do=2&action=empty&table=".rawurlencode($tableName)."&redirect=".rawurlencode("index.php?do=2&table=$tableName")).'" onclick="return confirm(\''.common::javascriptEscapeString(common::lang('Are you sure you want to delete all rows from this table?')).'\')">'.common::lang('Empty').'</a></li>';
		$out .= '<li><a class="'.$sel6.'" href="'.common::url("index.php?do=2&action=drop&table=".rawurlencode($tableName)).'" onclick="return confirm(\''.common::javascriptEscapeString(common::lang('Are you sure you want to drop this table?')).'\')">'.common::lang('Drop').'</a></li>';
	$out .= '</ul>';
	$out .= '</div>';
	return $out;
    }
	    /**
     *
     * @param <type> $libv
     * @param <type> $phpv
     * @param <type> $dbName
     * @param <type> $format
     * @return <type>
     */
    function dumpSQL($libv, $phpv, $dbName, $format = 'sql')
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	$tables = $DB->get_col("SELECT name FROM sqlite_master WHERE type = 'table'");
	$sqlOutput = '';
	if ($format = 'sql')
	{
	    $sqlOutput .= '-- phpSQLiteAdmin SQL Dump'."\n";
	    $sqlOutput .= '-- version '.$config['version']."\n";
	    $sqlOutput .= '-- http://www.phpsqliteadmin.com'."\n";
	    $sqlOutput .= '-- Generation Time: '.date("l jS \of F Y h:i:s A")."\n";
	    $sqlOutput .= '-- SQLite version: '.$libv."\n";
	    $sqlOutput .= '-- PHP Version: '.$phpv."\n\n";
	    $sqlOutput .= '--'."\n";
	    $sqlOutput .= '-- Database: '.$dbName."\n";
	    $sqlOutput .= '--'."\n";
	    foreach ($tables as $table)
	    {
		$structure = sqlite::get_table_structure($table);
		$i = 0;
		$numFields = count($structure);

		$sqlOutput .= '-- --------------------------------------------------------'."\n\n";
		$sqlOutput .= '--'."\n";
		$sqlOutput .= '-- Table structure for table '.$table."\n";
		$sqlOutput .= '--'."\n\n";
		$sqlOutput .= 'CREATE TABLE '.$table.' ('."\n";
		foreach($structure as $s)
		{
		    if ($s['notnull'] == 0)
		    {
			if ($s['dflt_value'] != '')
			{
			    $t1 = ' DEFAULT \''.$s['dflt_value'].'\'';
			}
			else
			{
			    $t1 = '';
			}
			$sqlOutput .= "\t".$s['name'].' '.$s['type'].' NULL'.$t1;
		    }
		    else
		    {
			if ($s['dflt_value'] != '')
			{
			    $t1 = ' DEFAULT \''.$s['dflt_value'].'\'';
			}
			else
			{
			    $t1 = '';
			}
			$sqlOutput .= "\t".$s['name'].' '.$s['type'].' NOT NULL'.$t1;
		    }
		    if ($i < $numFields-1) $sqlOutput .= ','."\n";
		    else $sqlOutput .= "\n";
		    $i++;
		}
		$sqlOutput .= ');'."\n\n";
		$t2 = '';
		$t3 = '';
		$z = 0;
		foreach($structure as $s)
		{
		    if ($z < $numFields-1) $t2 .= $s['name'].', ';
		    else $t2 .= $s['name'];
		    $z++;
		}
		$result = $DB->query("SELECT * FROM ".$table);
		if ($result->num_rows() > 0)
		{
		    $sqlOutput .= 'INSERT INTO '.$table.' ('.$t2.') VALUES ('."\n";
		    $result = $DB->query("SELECT * FROM ".$table);
		    while ($row = $result->fetch_row())
		    {
			$numData = count($row);
			$t3 .= '(';
			$n = 0;
			foreach ($row as $k => $v)
			{
			    if ($n < $numData -1) $t3 .= '\''.$v.'\', ';
			    else $t3 .= '\''.$v.'\'';
			    $n++;
			}
			$t3 .= '), '."\n";
		    }
		    $sqlOutput .= substr($t3, 0, -3)."\n";
		    $sqlOutput .= ');'."\n";
		}
	    }
	}
	return $sqlOutput;
    }

    /**
     *
     * @global <type> $DB
     * @param <type> $autoIncrement
     * @return <type>
     */
    function parseRowData($autoIncrement = null)
    {
	global $DB;
	foreach ($_POST['rowData'] as $columnName => $columnValue)
	{
	    if (!is_null($autoIncrement) AND $columnName == $autoIncrement)
	    {
		continue;
	    }
	    if (!empty($_POST['null'][$columnName]))
	    {
		$sqlFields = $columnName;
		$sqlValues = 'NULL';
	    }
	    else if (!empty($_POST['functions'][$columnName]))
		{
		    list($functionType, $functionName) = explode(':', $_POST['functions'][$columnName]);
		    if ($functionType == 'php')
		    {
			$columnValue = $DB->quote(call_user_func($functionName, $columnValue));
		    }
		    else if ($functionType == 'sqlite')
			{
			    if (sqlite::get_num_arguments(strtolower($functionName)) == 0)
			    {
				$columnValue = "$functionName()";
			    }
			    else
			    {
				$columnValue = $DB->quote($columnValue);
				$columnValue = "$functionName($columnValue)";
			    }
			}
		    $sqlFields[] = $columnName;
		    $sqlValues[] = $columnValue;
		}
		else
		{
		    $sqlFields[] = $columnName;
		    $sqlValues[] = $DB->quote($_POST['rowData'][$columnName]);
		}
	}
	return array($sqlFields, $sqlValues);
    }

    /**
     * Enter description here...
     *
     * @param <type> $db
     * @param <type> $type
     * @return <type>
     */
    function generateMenuDB($db, $type = 'sql')
    {
	$out = '';
	if (!empty($_SESSION['database']['name']))
	{
	    $out .= '<ul id="browser" class="filetree treeview">';
	    $out .= '<li><a href="'.common::url('index.php').'" target="_main"><span class="root">phpSQLiteAdmin</span></a><ul>';
	    if (!empty($db['path']))
	    {
		$DB = &database::singleton($db['params']);
		$tables = $DB->get_col("SELECT name FROM sqlite_master WHERE type = 'table'");
		$views = $DB->get_col("SELECT name FROM sqlite_master WHERE type = 'view'");
		$out .= '<li><a href="'.common::url('index.php?do=9').'" target="rightFrame"><span class="db">'.$db['name'].'</span></a><ul>';
		$out .= '<li><a href="#"><span class="folder">'.common::lang('Operations').'</span></a><ul>';
		$out .= '<li><a href="'.common::url('index.php?do=4').'" target="rightFrame"><span class="action">'.common::lang('Query').'</span></a></li>';
		$out .= '<li><a href="'.common::url('index.php?do=5').'" target="rightFrame"><span class="action">'.common::lang('Export').'</span></a></li>';
		$out .= '<li><a href="'.common::url('index.php?do=7').'" target="rightFrame"><span class="action">'.common::lang('Add Table').'</span></a></li>';
		$out .= '<li><a href="'.common::url('index.php?do=6&action=createView&view=null').'" target="rightFrame"><span class="action">'.common::lang('Add View').'</span></a></li>';
		$out .= '</ul></li>';
		$out .= '<li><a href="#"><span class="folder">'.common::lang('Tables').'</span></a>';
		if (count($tables) > 0)
		{
		    $out .= '<ul>';
		    foreach ($tables as $table)
		    {
			$out .= '<li><a href="'.common::url('index.php?do=2&table='.$table).'" target="rightFrame"><span class="table">'.$table.'</span></a></li>';
		    }
		    $out .= '</ul>';
		}
		$out .= '</li>';
		$out .= '<li><a href="#"><span class="folder">'.common::lang('Views').'</span></a>';
		if (count($tables) > 0)
		{
		    $out .= '<ul>';
		    foreach ($views as $view)
		    {
			$out .= '<li><a href="'.common::url('index.php?do=6&view='.$view).'" target="rightFrame"><span class="view">'.$view.'</span></a></li>';
		    }
		    $out .= '</ul>';
		}
		$out .= '</li>';
		$out .= '</ul></li>';
	    }
	    $out .= '</ul></li>';
	    $out .= '</ul></li>';
	}
	return $out;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $text
     * @param unknown_type $length
     * @param unknown_type $postfix
     * @return unknown
     */
    function truncateText($text, $length, $postfix = '...')
    {
	if (strlen($text) > $length)
	{
	    $text = substr($text, 0, $length) . $postfix;
	}
	return $text;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $error_msg
     * @param unknown_type $no_error
     */
    function errorMessage(&$error_msg, $no_error = '')
    {
	global $SESSION;
	if (!empty($_SESSION['common']['error_msg']))
	{
	    $error_msg = $_SESSION['common']['error_msg'];
	    unset($_SESSION['common']['error_msg']);
	}
	else
	{
	    $error_msg = $no_error;
	}
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $to
     * @param unknown_type $error_msg
     */
    function redirect($to, $error_msg = null)
    {
	if (!empty($error_msg))
	{
	    $_SESSION['common']['error_msg'] = $error_msg;
	}
	header('Location: '.common::url($to));
	exit;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $file
     * @return unknown
     */
    function url($file = null)
    {
	return $file;
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function getClientIP()
    {
	global $_SERVER;
	static $ip_address;
	if (@!$ip_address)
	{
	    $ip_address = !empty($_SERVER['CLIENT_IP']) ? $_SERVER['CLIENT_IP'] : '';
	    $ip_address = !empty($_SERVER['HTTP_X_FORWARDED_FOR']) && empty($ip_address)? $_SERVER['HTTP_X_FORWARDED_FOR'] : $ip_address;
	    $ip_address = !empty($_SERVER['REMOTE_ADDR']) && empty($ip_address)? $_SERVER['REMOTE_ADDR'] : $ip_address;
	}
	return $ip_address;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $template
     * @return unknown
     */
    function getTemplate($template)
    {
	global $config;
	$templates_dir = $config['base_dir'].'themes/default'.DIRECTORY_SEPARATOR;
	if (file_exists($templates_dir.$template))
	{
	    return $templates_dir.$template;
	}
	else
	{
	    return false;
	}
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $input
     */
    function stripslashes_r(&$input)
    {
	common::applyFunction($input, 'stripslashes');
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $input
     * @param unknown_type $function
     */
    function applyFunction(&$input, $function)
    {
	foreach ($input as $k => $v)
	{
	    if (is_array($v))
	    {
		common::applyFunction($input[$k], $function);
	    }
	    else
	    {
		$input[$k] = $function($v);
	    }
	}
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $filesize
     * @return unknown
     */
    function formatFilesize($filesize)
    {
	if ($filesize >= 1073741824)
	{
	    return number_format($filesize / 1073741824, 1).'Gb';
	}
	else if ($filesize >= 1048576)
	    {
		return number_format($filesize / 1048576, 1).'Mb';
	    }
	    else if ($filesize >= 1024)
		{
		    return number_format($filesize / 1024, 1).'Kb';
		}
		else
		{
		    return $filesize;
		}
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $text
     * @return unknown
     */
    function lang($text)
    {
	global $LANG, $config;
	if ($_SESSION['common']['lang'] == 'en')
	{
	    return $text;
	}
	else
	{
	    if (isset($_SESSION['common']['lang']))
	    {
		$lang = $_SESSION['common']['lang'];
	    }
	    else
	    {
		$lang = $config['languages']['default'];
	    }
	    if ($lang != 'en')
	    {
		include($config['base_dir'].'lang'.DIRECTORY_SEPARATOR.'lang.'.$lang.'.php');
		return $LANG[$text];
	    }
	    else
	    {
		return $text;
	    }
	}
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $string
     * @return unknown
     */
    function javascriptEscapeString($string)
    {
	$js_escape = array("\r" => '\r', "\n" => '\n', "\t" => '\t', "'"  => "\\'", '\\' => '\\\\');
	return strtr($string, $js_escape);
    }
}

					    ?>