<?php

/**
 phpSQLiteAdmin is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 phpSQLiteAdmin is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with phpSQLiteAdmin; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
 Copyright 2004 Richard Heyes
 Copyright 2006-2009 Marius Stanciu <marius.stanciu@code-purity.com>
 */

define('DB_FETCHMODE_ASSOC', SQLITE_ASSOC, true);
define('DB_FETCHMODE_NUM', SQLITE_NUM, true);
define('DB_FETCHMODE_BOTH', SQLITE_BOTH, true);

/**
 * Enter description here...
 *
 * @package		phpSQLiteAdmin
 * @subpackage		Core
 * @author		Marius Stanciu Sergiu <marius.stanciu@code-purity.com>
 * @copyright		Copyright (c) 2006-2009, Code Purity www.code-purity.com
 * @link		http://blog.code-purity.com/pages/phpsqliteadmin
 * @since		Version 0.1.0
 */

class database
{
    var $_query_logging;
    var $_query_log;
    var $_errors;
    var $_callbacks;
    var $fetch_mode;

    /**
     * Enter description here...
     *
     * @return database
     */
    function database()
    {
	$this->_errors = array();
	$this->_query_log = array();
	$this->_query_logging = false;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $params
     * @return unknown
     */
    function &factory($params)
    {
	if (empty($params['type']))
	{
	    return false;
	}
	if (empty($params['path']))
	{
	    $params['path'] = dirname(__FILE__).'/';
	}
	$objName = 'database_'.$params['type'];
	return new $objName($params);
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $params
     * @return unknown
     */
    function &singleton($params)
    {
	static $db;
	if (!isset($db))
	{
	    $db = database::factory($params);
	}
	return $db;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $mode
     */
    function set_fetch_mode($mode = DB_FETCHMODE_ASSOC)
    {
	$this->fetch_mode = $mode;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $query
     * @param unknown_type $dbas
     * @return unknown
     */
    function get_one($query, $dbas = null)
    {
	if (is_object($result = &$this->query($query, $dbas)))
	{
	    $result->set_fetch_mode(DB_FETCHMODE_NUM);
	    $return = $result->fetch_row();
	    $return = $return[0];
	    $result->free();
	}
	else
	{
	    $return = false;
	}
	return $return;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $query
     * @param unknown_type $dbas
     * @return unknown
     */
    function get_row($query, $dbas = null)
    {
	if (is_object($result = &$this->query($query, $dbas)))
	{
	    $return = $result->fetch_row();
	    $result->free();
	}
	else
	{
	    $return = false;
	}
	return $return;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $query
     * @param unknown_type $column
     * @param unknown_type $dbas
     * @return unknown
     */
    function get_col($query, $column = 0, $dbas = null)
    {
	$return = array();
	$result = $this->query($query, $dbas);
	if (is_object($result))
	{
	    while ($row = $result->fetch_row(DB_FETCHMODE_NUM))
	    {
		$return[] = $row[(int)$column];
	    }
	    return $return;
	}
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $query
     * @param unknown_type $dbas
     * @return unknown
     */
    function get_all($query, $dbas = null)
    {
	if (is_object($result = &$this->query($query, $dbas)))
	{
	    $return = array();
	    while ($row = $result->fetch_row())
	    {
		$return[] = $row;
	    }
	    $result->free();
	    return $return;
	}
	return false;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $query
     * @param unknown_type $dbas
     * @return unknown
     */
    function get_assoc($query, $dbas = null)
    {
	if (is_object($result = &$this->query($query, $dbas)))
	{
	    $return = array();
	    while ($row = $result->fetch_row(DB_FETCHMODE_NUM))
	    {
		$key = array_shift($row);
		$value = (count($row) == 1 ? $row[0] : $row);
		$return[$key] = $value;
	    }
	    $result->free();
	    return $return;
	}
	return false;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $callback
     */
    function add_error_handler(&$callback)
    {
	$this->_callbacks[] = &$callback;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $errorString
     */
    function throw_error($errorString)
    {
	$this->_errors[] = $errorString;
	for ($i=0; $i<count($this->_callbacks); ++$i)
	{
	    call_user_func_array($this->_callbacks[$i], $errorString);
	}
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function get_last_error()
    {
	if (!empty($this->_errors))
	{
	    return $this->_errors[count($this->_errors) - 1];
	}
	return '';
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function get_errors()
    {
	return $this->_errors;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $query
     * @param unknown_type $type
     */
    function log_query($query, $type = 'good')
    {
	if ($this->_query_logging)
	{
	    $this->_query_log[$type][] = $query;
	}
    }

    /**
     * Enter description here...
     *
     */
    function enable_query_logging()
    {
	$this->_query_logging = true;
	register_shutdown_function(array(&$this, 'print_query_summary'));
    }

    /**
     * Enter description here...
     *
     */
    function disable_query_logging()
    {
	$this->_query_logging = false;
    }

    /**
     * Enter description here...
     *
     */
    function print_query_summary()
    {
	if (!empty($this->_query_log['good']))
	{
	    printf('<br /><table border="0" style="width: 100%%; background-color: #00c000; border: 1px dashed #000000"><tr><td>%s</td></tr></table><br />', implode('</td></tr><tr><td>', $this->_query_log['good']));
	}
	if (!empty($this->_query_log['bad']))
	{
	    printf('<br /><table border="0" style="width: 100%%; background-color: #F68500; border: 1px dashed #000000"><tr><td>%s</td></tr></table>', implode('</td></tr><tr><td>', $this->_query_log['bad']));
	}
    }
}

/**
 * Enter description here...
 *
 * @package		phpSQLiteAdmin
 * @subpackage	Core
 * @author		Marius Stanciu Sergiu <marius.stanciu@code-purity.com>
 * @copyright	Copyright (c) 2006-2009, Code Purity www.code-purity.com
 * @link		http://blog.code-purity.com/pages/phpsqliteadmin
 * @since		Version 0.1.0
 */

class sqlite
{
/**
 * Enter description here...
 *
 * @return unknown
 */
    function get_database_list()
    {
	global $config;
	$databases = array();
	if (!empty($config['databases']['database']))
	{
	    foreach ($config['databases']['database'] as $db)
	    {
		$exists = (int)file_exists($db['path']);
		$writeable = (int)($exists AND is_writeable($db['path']));
		$databases[] = array('path' => $db['path'], 'desc' => $db['desc'], 'name' => $db['name'], 'exists' => $exists, 'writeable' => $writeable);
	    }
	}
	return $databases;
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function get_table_list()
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	$tables = $DB->get_all("SELECT * FROM sqlite_master WHERE type = 'table'");
	foreach ($tables as $k => $v)
	{
	    $tables[$k]['records'] = $DB->get_one("SELECT COUNT(*) FROM $v[name]");
	}
	return $tables;
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function get_view_list()
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	$views = $DB->get_all("SELECT * FROM sqlite_master WHERE type = 'view'");
	return $views;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $table
     * @param unknown_type $getExtendedInfo
     * @return unknown
     */
    function get_index_list($table, $getExtendedInfo = false)
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	$table = sqlite::sanitise_identifier($table, true);
	$indexes = $DB->get_all("PRAGMA index_list($table)");
	if ($getExtendedInfo)
	{
	    foreach ($indexes as $k => $index)
	    {
		$indexInfo = sqlite::get_index_info($index['name']);
		$indexes[$k]['column'] = $indexInfo['name'];
	    }
	}
	return $indexes;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $index
     * @return unknown
     */
    function get_index_info($index)
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	return $DB->get_row("PRAGMA index_info('$index')");
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $table
     * @return unknown
     */
    function get_table_structure($table)
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	$table =  sqlite::sanitise_identifier($table, true);
	$structure = $DB->get_all("PRAGMA table_info($table)");
	foreach ($structure as $k => $v)
	{
	    if ($v['pk'] AND strcasecmp($v['type'], 'integer') == 0)
	    {
		$structure[$k]['autoincrement'] = true;
	    }
	    else
	    {
		$structure[$k]['autoincrement'] = false;
	    }
	}
	return $structure;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $view
     * @return unknown
     */
    function get_view_properties($view)
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	$view = sqlite::sanitise_identifier($view);
	$result = $DB->get_one("SELECT sql FROM sqlite_master WHERE name = '$view'");
	if ($result)
	{
	    preg_match('/^CREATE\s+(TEMP\s+|TEMPORARY\s+)?VIEW\s+(\[?[a-z][a-z0-9]*\]?)\s+AS\s+(.+)$/i', $result, $matches);
	    $return['name'] = $view;
	    $return['temporary'] = !empty($matches[1]);
	    $return['sql'] = $matches[3];
	    return $return;
	}
	else
	{
	    return false;
	}
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $view
     * @return unknown
     */
    function drop_view($view)
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	$view = sqlite::sanitise_identifier($view, true);
	return $DB->query("DROP VIEW $view");
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $name
     * @param unknown_type $sql
     * @param unknown_type $temporary
     * @return unknown
     */
    function create_view($name, $sql, $temporary = false)
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	$name = sqlite::sanitise_identifier($name, true);
	$temporary = $temporary ? 'TEMPORARY' : '';
	$createSql = "CREATE $temporary VIEW $name AS $sql";
	return $DB->query($createSql);
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $input
     * @param unknown_type $brackets
     * @return unknown
     */
    function sanitise_identifier($input, $brackets = false)
    {
	$input = preg_replace('/[^a-z0-9]/i', '', $input);
	if ($brackets)
	{
	    $input = "[$input]";
	}
	return $input;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $rowid
     * @param unknown_type $table
     * @return unknown
     */
    function delete_row($rowid, $table)
    {
	$DB = &database::singleton($_SESSION['database']['params']);
	$table = sqlite::sanitise_identifier($table, true);
	return (bool)$DB->query("DELETE FROM $table WHERE _ROWID_ = $rowid");
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function get_user_functions()
    {
	global $config;
	static $functionCache;
	if (!empty($functionCache))
	{
	    return $functionCache;
	}
	$DB = &database::singleton($_SESSION['database']['params']);
	$functions_pre = get_defined_functions();
	$returnList = array();
	$path = $config['base_dir'].'include/functions/';
	$dir = opendir($path);
	while ($filename = readdir($dir))
	{
	    if (preg_match('/^sqlite_user_.+\.php$/', $filename))
	    {
		include($path . $filename);
	    }
	}
	$functions_post = get_defined_functions();
	$functions = array_diff($functions_post['user'], $functions_pre['user']);
	foreach ($functions as $actual)
	{
	    if ($friendly = preg_replace('/^sqlite_user_/', '', $actual))
	    {
		$returnList[] = array('actual' => $actual, 'friendly' => $friendly);
		sqlite_create_function($DB->db_handle, $actual, $actual);
	    }
	}
	$functionCache = $returnList;
	return $returnList;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $function
     * @return unknown
     */
    function get_num_arguments($function)
    {
	$functions = array('abs' => 1,
	    'date' => 1,
	    'datetime' => 1,
	    'last_insert_rowid' => 0,
	    'length' => 1,
	    'lower' => 1,
	    'random' => 0,
	    'round' => 1,
	    'soundex' => 1,
	    'sqlite_version' => 0,
	    'upper' => 1
	);
	if (isset($functions[$function]))
	{
	    return $functions[$function];
	}
	else
	{
	    return null;
	}
    }
}

/**
 * Enter description here...
 *
 * @package		phpSQLiteAdmin
 * @subpackage		Core
 * @author		Marius Stanciu Sergiu <marius.stanciu@code-purity.com>
 * @copyright		Copyright (c) 2006-2009, Code Purity www.code-purity.com
 * @link		http://blog.code-purity.com/pages/phpsqliteadmin
 * @since		Version 0.1.0
 */
class database_sqlite extends database
{
    var $dbas;
    var $db_handle;

    /**
     * Enter description here...
     *
     * @param unknown_type $params
     * @return database_sqlite
     */
    function database_sqlite($params)
    {
	$this->database();
	$this->dbas = $params['dbas'];
	$this->connect($params['dbas']);
	$this->set_fetch_mode(DB_FETCHMODE_ASSOC);
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $dbas
     * @return unknown
     */
    function connect($dbas)
    {
	$this->db_handle = sqlite_open($dbas, 0666, $error_string);
	if (!empty($error_string))
	{
	    $this->throw_error($error_string);
	}
	return is_resource($this->db_handle);
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function is_connected()
    {
	return is_resource($this->db_handle);
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $dbas
     * @return unknown
     */
    function set_database($dbas)
    {
	if ($this->connect($dbas))
	{
	    $this->dbas = $dbas;
	    return true;
	}
	return false;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $string
     * @return unknown
     */
    function quote($string)
    {
	return "'".sqlite_escape_string($string)."'";
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $query
     * @param unknown_type $dbas
     * @param unknown_type $unbuffered
     * @return unknown
     */
    function query($query, $dbas = null, $unbuffered = null)
    {
	if (!is_null($unbuffered) AND $unbuffered)
	{
	    $query_function = 'sqlite_unbuffered_query';
	}
	else
	{
	    $query_function = 'sqlite_query';
	}
	if (!is_null($dbas))
	{
	    $this->set_database($dbas);
	}
	if ($result = @call_user_func($query_function, $query, $this->db_handle) AND preg_match('/^(select|explain|pragma)/i', $query))
	{
	    $return = new database_sqlite_result($result);
	    $return->set_fetch_mode($this->fetch_mode);
	}
	else
	{
	    $return = (bool)$result;
	}
	$this->log_query($query, $result ? 'good' : 'bad');
	if (!is_null($dbas))
	{
	    $this->set_database($this->dbas);
	}
	$this->check_for_error();
	return $return;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $query
     * @param unknown_type $dbas
     * @return unknown
     */
    function u_query($query, $dbas = null)
    {
	return $this->query($query, $dbas, true);
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function check_for_error()
    {
	if ($error_code = sqlite_last_error($this->db_handle))
	{
	    $this->throw_error(sqlite_error_string($error_code));
	    return true;
	}
	return false;
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function get_encoding()
    {
	return sqlite_libencoding();
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function get_version()
    {
	return sqlite_libversion();
    }
}

/**
 * Enter description here...
 *
 * @package		phpSQLiteAdmin
 * @subpackage	Core
 * @author		Marius Stanciu Sergiu <marius.stanciu@code-purity.com>
 * @copyright	Copyright (c) 2006-2009, Code Purity www.code-purity.com
 * @link		http://blog.code-purity.com/pages/phpsqliteadmin
 * @since		Version 0.1.0
 */

class database_sqlite_result
{
    var $result;
    var $fetch_mode;
    var $current_row;

    /**
     * Enter description here...
     *
     * @param unknown_type $result
     * @return database_sqlite_result
     */
    function database_sqlite_result(&$result)
    {
	$this->result = &$result;
	$this->fetch_mode = DB_FETCHMODE_ASSOC;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $mode
     * @return unknown
     */
    function set_fetch_mode($mode = DB_FETCHMODE_ASSOC)
    {
	$oldmode = $this->fetch_mode;
	$this->fetch_mode = $mode;
	return $oldmode;
    }

    /**
     * Enter description here...
     *
     * @param unknown_type $mode
     * @return unknown
     */
    function fetch_row($mode = null)
    {
	$mode = !empty($mode) ? $mode : $this->fetch_mode;
	$this->current_row = sqlite_fetch_array($this->result, $mode);
	return $this->current_row;
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function num_rows()
    {
	return sqlite_num_rows($this->result);
    }

    /**
     * Enter description here...
     *
     * @return unknown
     */
    function free()
    {
	return false;
    }
}
?>