function form(formName)
{
    this.formObj = document.forms[formName];
    this.elements = this.formObj.elements;
    this.getValue = form_getValue;
    this.setValue = form_setValue;
    this.getChecked = form_getChecked;
    this.setChecked = form_setChecked;
    this.getDisabled = form_getDisabled;
    this.setDisabled = form_setDisabled;
    this.numSelected = form_numSelected;
    this.getSelectedIndex = form_getSelectedIndex;
    this.setSelectedIndex = form_setSelectedIndex;
    this.addOptionToSelect = form_addOptionToSelect;
    this.removeOptionFromSelect = form_removeOptionFromSelect;
    this.numOptions = form_numOptions;
    this.setSelectedOptionValue = form_setSelectedOptionValue;
    this.setSelectedOptionText  = form_setSelectedOptionText;
    this.swapOptions = form_swapOptions;
}

function form_getValue(inputName)
{
    var returnValue = '';
    var type = null;
    switch (this.elements[inputName].type)
    {
	case 'button':
	case 'hidden':
	case 'text':
	    returnValue = this.elements[inputName].value;
	    break;
	case 'checkbox':
	    returnValue = this.elements[inputName].checked ? this.elements[inputName].value : null;
	    break;
	case 'select-one':
	    returnValue = this.elements[inputName].options[this.elements[inputName].selectedIndex].value;
	    break;
	case 'select-multiple':
	    break;
    }
    return returnValue;
}

function form_setValue(inputName, value)
{
    switch (this.elements[inputName].type)
    {
	case 'button':
	case 'hidden':
	case 'text':
	    this.elements[inputName].value = value;
	    break;
	case 'select-one':
	    for (var i=0; i < this.elements[inputName].options.length; ++i)
	    {
		if (this.elements[inputName].options[i].value == value)
		{
		    this.elements[inputName].selectedIndex = i;
		    return;
		}
	    }
	    break;
	case 'checkbox':
	    this.elements[inputName].value = value;
	    break;
    }
}

function form_getChecked(inputName)
{
    return this.elements[inputName].checked;
}

function form_setChecked(inputName, checked)
{
    this.elements[inputName].checked = checked;
}

function form_getDisabled(inputName)
{
    return this.elements[inputName].disabled;
}

function form_setDisabled(inputName, disabled)
{
    this.elements[inputName].disabled = disabled;
}

function form_numSelected(selectName)
{
    var selectObj = this.elements[selectName];
    var selected = 0;
    for (var i=0; i < selectObj.options.length; ++i)
    {
	if (selectObj.options[i].selected) selected++;
    }
    return selected;
}

function form_getSelectedIndex(selectName)
{
    var selectObj = this.elements[selectName];
    if (this.numSelected(selectName) > 1)
    {
	var selected = new Array();
	for (var i=0; i < selectObj.options.length; ++i)
	{
	    if (selectObj.options[i].selected) selected[selected.length] = i;
	}
	return selected;
    }
    else return selectObj.selectedIndex;
}

function form_setSelectedIndex(selectName, selectedIndex)
{
    this.elements[selectName].selectedIndex = selectedIndex;
}

function form_addOptionToSelect(selectName, option)
{
    this.elements[selectName].options[this.elements[selectName].options.length] = option;
}

function form_removeOptionFromSelect(selectName, optionIndex)
{
    var selectObj = this.elements[selectName];
    if (selectObj.options[optionIndex]) selectObj.options[optionIndex] = null;
}

function form_numOptions(selectName)
{
    return formObj.elements[selectName].options.length;
}

function form_setSelectedOptionValue(selectName, value)
{
    var selectObj = this.elements[selectName];
    var optionObj = selectObj.options[selectObj.selectedIndex];
    if (this.numSelected(selectName) == 1) optionObj.value = value;
}

function form_setSelectedOptionText(selectName, text)
{
    var selectObj = this.elements[selectName];
    var optionObj = selectObj.options[selectObj.selectedIndex];
    if (this.numSelected(selectName) == 1) optionObj.text = text;
}

function form_swapOptions(selectName, a, b)
{
    var optionsArray = this.elements[selectName].options;
    if(optionsArray[a] && optionsArray[b])
    {
	tmp_a = optionsArray[a];
	optionsArray[a] = new Option(optionsArray[b].text, optionsArray[b].value);
	optionsArray[b] = tmp_a;
    }
    return optionsArray;
}