<?php
/**
 phpSQLiteAdmin is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 phpSQLiteAdmin is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with phpSQLiteAdmin; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Copyright 2004 Richard Heyes
 Copyright 2006-2009 Marius Stanciu <marius.stanciu@code-purity.com>
 */

/**
 * Enter description here...
 *
 * @package		phpSQLiteAdmin
 * @author		Marius Stanciu Sergiu <marius.stanciu@code-purity.com>
 * @copyright		Copyright (c) 2006-2009, Code Purity www.code-purity.com
 * @link		http://blog.code-purity.com/pages/phpsqliteadmin
 * @since		Version 0.1.0
 */

include('config/config.php');
include($config['base_dir'].'include/initialize.php');
$do = intval($_GET['do']);
switch ($do)
{
    case 9:
	if (empty($_SESSION['database']['name']))
	{
	    common::redirect('index.php?do=9', common::lang('No database name given!'));
	}
	$DB = &database::singleton($_SESSION['database']['params']);
	$tables = sqlite::get_table_list();
	$totalRecords = 0;
	$views = sqlite::get_view_list();
	$filemtime = filemtime($_SESSION['database']['path']);
	$xDaysAgo = number_format((time() - $filemtime)/86400, 1).common::lang(' days ago');
	$template = 'database.tpl';
	break;
    case 1:
	if (empty($_SESSION['database']['name']))
	{
	    common::redirect('index.php?do=9', common::lang('No database name given!'));
	}
	if (isset($_GET['table']))
	{
	    $tableName = htmlspecialchars($_GET['table']);
	}
	else if (isset($_POST['table']))
	    {
		$tableName = htmlspecialchars($_POST['table']);
	    }
	$DB = &database::singleton($_SESSION['database']['params']);
	if (!empty($_POST['sql']))
	{
	    $sql = $origSql = trim($_POST['sql']);
	    $identifier = '([a-z][a-z0-9_]*|\[[a-z][a-z0-9_]*\])';
	    if (!preg_match('/\s+FROM\s+[a-z]/i', $sql) OR preg_match('/(NATURAL)?\s*(LEFT|RIGHT|FULL)?\s*(OUTER|INNER|CROSS)?\s*JOIN/i', $sql) OR preg_match("/\s+FROM\s+$identifier\s*,/i", $sql) OR preg_match('/^SELECT.+\(.+FROM/Ui', $sql))
	    {
		$showEditDelete = false;
	    }
	    else
	    {
		preg_match("/\s+FROM\s+$identifier\s*/i", $sql, $matches);
		$tablename = $matches[1];
		$showEditDelete = ($tablename != 'sqlite_master' ? true : false);
	    }
	    if (!preg_match('/LIMIT\s+([0-9]+)(\s+OFFSET\s+([0-9])+)?$/i', $sql, $matches) AND preg_match('/^SELECT/i', $sql))
	    {
		$sql .= ' LIMIT 30 OFFSET 0';
		$limitNumber = 30;
		$offsetNumber = 0;
	    }
	    else
	    {
		$limitNumber = @$matches[1];
		$offsetNumber = @$matches[3];
	    }
	    if (preg_match('/^select /i', $sql) AND $showEditDelete)
	    {
		$sql = preg_replace('/^(select) /i', '$1 _ROWID_, ', $sql);
	    }
	    $result = $DB->query($sql);
	    $querySuccessful = is_object($result) OR $result;
	    $queryHasResults = is_object($result) AND $result->num_rows() > 0;
	    if ($queryHasResults)
	    {
		$resultsTable = array();
		$headers = array();
		while ($row = $result->fetch_row())
		{
		    $resultsRow = array();
		    if (empty($headers))
		    {
			$headers = array_slice(array_keys($row), $showEditDelete ? 1 : 0);
		    }
		    foreach ($row as $k => $v)
		    {
			if ($k == '_ROWID_' AND empty($resultsRow) AND $showEditDelete)
			{
			    $resultsRow[] = sprintf('<nobr><a href="%s" title="%s"><span class="ui-icon ui-icon-document"></span></a> <a href="%s" title="%s" onclick="return confirm(\'%s\')"><span class="ui-icon ui-icon-trash"></a></nobr>', common::url("index.php?do=3&action=edit&table=$tablename&rowid=$v&redirect=".rawurlencode(common::url())), common::lang('Edit'), common::url("index.php?do=3&action=delete&table=$tablename&rowid=$v&redirect=".rawurlencode(common::url())),  common::lang('Delete'), common::lang('Are you sure you want to delete this row?'));
			}
			else
			{
			    $resultsRow[] = $v;
			}
		    }
		    $resultsTable[] = $resultsRow;
		}
	    }
	}
	$origSql = "SELECT * FROM ".htmlspecialchars($tableName);
	$template = 'query.tpl';
	break;
    case 2:
	if (empty($_SESSION['database']['name']))
	{
	    common::redirect('index.php?do=9', common::lang('No database name given!'));
	}
	if (empty($_GET['table']))
	{
	    common::redirect('index.php?do=9', common::lang('No table given!'));
	}
	else
	{
	    $tableName = htmlspecialchars($_GET['table']);
	}
	$DB = &database::singleton($_SESSION['database']['params']);
	switch (@$_GET['action'])
	{
	    case 'addindex':
		if (!empty($_GET['column']) AND !empty($_GET['index']))
		{
		    $index = htmlspecialchars($_GET['index']);
		    $column = htmlspecialchars($_GET['column']);
		    $unique = !empty($_GET['unique']) ? 'UNIQUE' : '';
		    $result = $DB->query("CREATE $unique INDEX $index ON $tableName ($column)");
		    $message = $result ? null : common::lang('Failed to create index, SQLite said: ').$DB->get_last_error();
		    common::redirect("index.php?do=2&table=$tableName", $message);
		}
		else common::redirect("index.php?do=2&table=$tableName", common::lang('Column or index name missing - cannot create index'));
		break;
	    case 'dropindex':
		if (!empty($_GET['index']))
		{
		    $index = htmlspecialchars($_GET['index']);
		    $result = $DB->query("DROP INDEX $index");
		    $message = $result ? null : common::lang('Failed to create index, SQLite said: ').$DB->get_last_error();
		    common::redirect("index.php?do=2&table=$tableName", $message);
		}
		else
		{
		    common::redirect("index.php?do=2table=$tableName", common::lang('Index name missing - cannot drop index'));
		}
		break;
	    case 'empty':
		$result = $DB->query("DELETE FROM $tableName");
		$message = $result ? sprintf(common::lang('Table %s was emptied'), $tableName)  : common::lang('Failed to empty table!');
		$redirect = !empty($_GET['redirect']) ? htmlspecialchars($_GET['redirect']) : 'index.php?do=9';
		common::redirect($redirect, $message);
		break;
	    case 'drop':
		$result = $DB->query("DROP TABLE $tableName");
		$message = $result ? sprintf(common::lang('Table %s was dropped'), $tableName) : 'Failed to empty table!';
		$redirect = !empty($_GET['redirect']) ? htmlspecialchars($_GET['redirect']) : 'index.php?do=9';
		common::redirect($redirect, $message);
		break;
	    default:
		$structure = sqlite::get_table_structure($tableName);
		$rowCount = count($structure);
		$indexes = sqlite::get_index_list($tableName, true);
		break;
	}
	$template = 'table.tpl';
	break;
    case 3:
	if (empty($_SESSION['database']['name']))
	{
	    common::redirect('index.php?do=9', common::lang('No database name given!'));
	}
	if (empty($_GET['table']))
	{
	    common::redirect('index.php?do=9', common::lang('No table given!'));
	}
	else
	{
	    $tableName = htmlspecialchars($_GET['table']);
	}
	if ($_GET['action'] != 'insert')
	{
	    if (empty($_GET['rowid']))
	    {
		common::redirect("index.php?do=2&table=$tableName", common::lang('No row ID given!'));
	    }
	    else
	    {
		$rowID = htmlspecialchars($_GET['rowid']);
	    }
	}
	switch ($_GET['action'])
	{
	    case 'delete':
		$result = sqlite::delete_row($rowID, $tableName);
		common::redirect(htmlspecialchars($_GET['redirect']), $result ? common::lang('Row deleted') : common::lang('Failed to delete row!'));
		break;
	    case 'edit':
		$isUpdate = true;
		$isInsert = false;
		$DB = &database::singleton($_SESSION['database']['params']);
		sqlite::get_user_functions();
		if (!empty($_POST))
		{
		    list($sqlFields, $sqlValues) = common::parseRowData();
		    foreach ($sqlFields as $k => $v)
		    {
			$sqlUpdates[] = "$v = $sqlValues[$k]";
		    }
		    $sqlUpdates = implode(', ', $sqlUpdates);
		    $sql = "UPDATE $tableName SET $sqlUpdates WHERE _ROWID_ = $rowID";
		    $result = $DB->query($sql);
		    $message = $result ? common::lang('Row updated') : common::lang('Failed to update row: ') . $DB->get_last_error();
		    if ($_POST['redirectType'] == 'return')
		    {
			$redirectTarget = !empty($_POST['redirect']) ? htmlspecialchars($_POST['redirect']) : "index.php?do=2&table=$tableName";
			common::redirect($redirectTarget, $message);
		    }
		    else if ($_POST['redirectType'] == 'insert')
			{
			    $redirect = rawurlencode(htmlspecialchars($_POST['redirect']));
			    common::redirect("index.php?do=3&action=insert&table=$tableName&redirect=$redirect", $message);
			}
		}
		$tableStructure = sqlite::get_table_structure($tableName);
		$rowData = $DB->get_row("SELECT * FROM $tableName WHERE _ROWID_ = $rowID");
		$pageTitle = common::lang('Edit row');
		$submitLabel = common::lang('Update Row');
		$formAction = 'edit';
		break;
	    case 'insert':
		$isUpdate = false;
		$isInsert = true;
		if (!empty($_POST))
		{
		    $DB = &database::singleton($_SESSION['database']['params']);
		    sqlite::get_user_functions();
		    $primaryKey = null;
		    $autoIncrement = null;
		    $tableStructure = sqlite::get_table_structure($tableName);
		    foreach ($tableStructure as $column)
		    {
			if ($column['pk'])
			{
			    $primaryKey = $column['name'];
			}
			if ($column['autoincrement'])
			{
			    $autoIncrement = $column['name'];
			}
		    }
		    $sqlFields = implode(', ', $sqlFields);
		    $sqlValues = implode(', ', $sqlValues);
		    $sql = "INSERT INTO $tableName ($sqlFields) VALUES($sqlValues)";
		    $result = $DB->query($sql);
		    $message = $result ? common::lang('Row inserted') : common::lang('Failed to insert row: ').$DB->get_last_error();
		    if ($_POST['redirectType'] == 'return')
		    {
			$redirectTarget = !empty($_POST['redirect']) ? htmlspecialchars($_POST['redirect']) : "index.php?do=2&table=$tableName";
			common::redirect($redirectTarget, $message);
		    }
		    else if ($_POST['redirectType'] == 'insert')
			{
			    $redirect = rawurlencode(htmlspecialchars($_POST['redirect']));
			    common::redirect("index.php?do=3&action=insert&table=$tableName&redirect=$redirect", $message);
			}
		}
		$tableStructure = sqlite::get_table_structure($tableName);
		foreach ($tableStructure as $t)
		{
		    $rowData[$t['name']] = $t['dflt_value'];
		}
		$pageTitle = common::lang('Insert new row');
		$submitLabel = common::lang('Add Row');
		$formAction = 'insert';
		break;
	    default:
		common::redirect("index.php?do=2&table=$tableName", common::lang('Unknown/no action given!'));
		break;
	}
	$userFunctions = sqlite::get_user_functions();
	$template = 'row.tpl';
	break;
    case 4:
	if (empty($_SESSION['database']['name']))
	{
	    common::redirect('index.php?do=9', common::lang('No database name given!'));
	}
	$DB = &database::singleton($_SESSION['database']['params']);
	if (!empty($_GET['sql']))
	{
	    $sqlTemp = $_GET['sql'];
	}
	else if (!empty($_POST['sql']))
	    {
		$sqlTemp = $_POST['sql'];
	    }
	    else
	    {
		$sqlTemp = '';
	    }
	if ($sqlTemp != '')
	{
	    $sql = $origSql = trim($sqlTemp);
	    $identifier = '([a-z][a-z0-9_]*|\[[a-z][a-z0-9_]*\])';
	    if (!preg_match('/\s+FROM\s+[a-z]/i', $sql) OR preg_match('/(NATURAL)?\s*(LEFT|RIGHT|FULL)?\s*(OUTER|INNER|CROSS)?\s*JOIN/i', $sql) OR preg_match("/\s+FROM\s+$identifier\s*,/i", $sql) OR preg_match('/^SELECT.+\(.+FROM/Ui', $sql))
	    {
		$showEditDelete = false;
	    }
	    else
	    {
		preg_match("/\s+FROM\s+$identifier\s*/i", $sql, $matches);
		$tablename = $matches[1];
		$showEditDelete = ($tablename != 'sqlite_master' ? true : false);
	    }
	    if (!preg_match('/LIMIT\s+([0-9]+)(\s+OFFSET\s+([0-9])+)?$/i', $sql, $matches) AND preg_match('/^SELECT/i', $sql))
	    {
		$sql .= ' LIMIT 30 OFFSET 0';
		$limitNumber = 30;
		$offsetNumber = 0;
	    }
	    else
	    {
		$limitNumber = @$matches[1];
		$offsetNumber = @$matches[3];
	    }
	    if (preg_match('/^select /i', $sql) AND $showEditDelete)
	    {
		$sql = preg_replace('/^(select) /i', '$1 _ROWID_, ', $sql);
	    }
	    $result = $DB->query($sql);
	    $querySuccessful = is_object($result) OR $result;
	    $queryHasResults = is_object($result) AND $result->num_rows() > 0;
	    if ($queryHasResults)
	    {
		$resultsTable = array();
		$headers = array();
		while ($row = $result->fetch_row())
		{
		    $resultsRow = array();
		    if (empty($headers))
		    {
			$headers = array_slice(array_keys($row), $showEditDelete ? 1 : 0);
		    }
		    foreach ($row as $k => $v)
		    {
			if ($k == '_ROWID_' AND empty($resultsRow) AND $showEditDelete)
			{
			    $resultsRow[] = sprintf('<nobr><a href="%s" title="%s"><span class="ui-icon ui-icon-document"></span></a> <a href="%s" title="%s" onclick="return confirm(\'%s\')"><span class="ui-icon ui-icon-trash"></a></nobr>', common::url("index.php?do=3&action=edit&table=$tablename&rowid=$v&redirect=".rawurlencode(common::url())), common::lang('Edit'), common::url("index.php?do=3&action=delete&table=$tablename&rowid=$v&redirect=".rawurlencode(common::url())),  common::lang('Delete'), common::lang('Are you sure you want to delete this row?'));
			}
			else
			{
			    $resultsRow[] = $v;
			}
		    }
		    $resultsTable[] = $resultsRow;
		}
	    }
	}
	$template = 'dbquery.tpl';
	break;
    case 5:
	if (empty($_SESSION['database']['name']))
	{
	    common::redirect('index.php?do=9', common::lang('No database name given!'));
	}
	$libVersion  = sqlite_libversion();
	$phpVersion = phpversion();
	$sqlOutput = common::dumpSQL($libVersion, $phpVersion, $_SESSION['database']['name']);
	$template = 'export.tpl';
	break;
    case 6:
	if (empty($_SESSION['database']['name']))
	{
	    common::redirect('index.php?do=9', common::lang('No database name given!'));
	}
	if (empty($_GET['view']))
	{
	    common::redirect('index.php?do=9', common::lang('No view name given!'));
	}
	else
	{
	    $viewName = htmlspecialchars($_GET['view']);
	}
	$DB = &database::singleton($_SESSION['database']['params']);
	switch (@$_GET['action'])
	{
	    case 'editView':
		if (!empty($_POST))
		{
		    $DB = &database::singleton($_SESSION['database']['params']);
		    $result = $DB->query('BEGIN TRANSACTION');
		    $result = $result AND sqlite::drop_view($viewName);
		    $result = $result AND sqlite::create_view($_POST['viewName'], $_POST['viewSql'], !empty($_POST['viewTemporary']));
		    if ($result)
		    {
			$query = 'COMMIT TRANSACTION';
			$message = common::lang('View updated');
		    }
		    else
		    {
			$query = 'ROLLBACK TRANSACTION';
			$message = sprintf(common::lang('Failed to update view, SQLite said: %s'), $DB->get_last_error());
		    }
		    $DB->query($query);
		    common::redirect('index.php?do=6&view='.rawurlencode($_POST['viewName']), $message);
		}
		else
		{
		    common::redirect('index.php?do=6&view=');
		}
		break;
	    case 'drop':
		$message = sqlite::drop_view($viewName) ? sprintf(common::lang('Dropped view <i>%s</i>'), $viewName) : common::lang('Failed to drop view, SQLite said: ') . $DB->get_last_error();
		common::redirect('index.php?do=9');
		break;
	    case 'createView':
		if (!empty($_POST))
		{
		    if (!empty($_POST['viewName']) AND !empty($_POST['viewSql']))
		    {
			$result = sqlite::create_view($_POST['viewName'], $_POST['viewSql'], !empty($_POST['viewTemporary']));
			if ($result)
			{
			    $message = sprintf(common::lang('View <i>%s</i> created'), $_POST['viewName']);
			    $redirect = 'index.php?do=6&view=' . sqlite::sanitise_identifier($_POST['viewName']);
			}
			else
			{
			    $message = sprintf(common::lang('Failed to create view, SQLite said: %s'), $DB->get_last_error());
			    $redirect = 'index.php?do=6&view=null&action=createView';
			}
			common::redirect($redirect, $message);
		    }
		    else
		    {
			common::redirect('index.php?do=6&action=createView&view=null', common::lang('Either name or SQL missing!'));
		    }
		}
		$pageTitle = common::lang('Create View');
		$formAction = 'createView';
		$submitValue = common::lang('Create View');
		break;
	    default:
		$showBrowse = true;
		$pageTitle = sprintf(common::lang('Properties for <i>%s</i>'), $viewName);
		$formAction = 'editView';
		$submitValue = common::lang('Save Changes');
		$viewProperties = sqlite::get_view_properties($viewName);
		break;
	}
	$template = 'view.tpl';
	break;
    case 7:
	if (empty($_SESSION['database']['name']))
	{
	    common::redirect('index.php?do=9', common::lang('No database name given!'));
	}
	if (!empty($_POST))
	{
	    if (!empty($_POST['columns']) AND !empty($_POST['tableName']))
	    {
		$columns = explode('|', $_POST['columns']);
		foreach ($columns as $col)
		{
		    $col = explode(':', $col);
		    $col[1] = strtoupper($col[1]);
		    $colSql = "$col[0] $col[1]";
		    if ($col[2] !== '')
		    {
			$colSql .= " ($col[2])";
		    }
		    if ($col[4] !== '1')
		    {
			$colSql .= " NOT NULL";
		    }
		    if ($col[3]!== '')
		    {
			$colSql .= " DEFAULT $col[3]";
		    }
		    if ($col[5] === 'primary')
		    {
			$colSql .= ' PRIMARY KEY';
		    }
		    else if ($col[5] === 'unique')
			{
			    $colSql .= ' UNIQUE';
			}
		    $sql[] = $colSql;
		}
		$sql = sprintf("CREATE %s TABLE %s (%s)", !empty($_POST['temporary']) ? 'TEMPORARY' : '', $_POST['tableName'], implode(', ', $sql));
		$DB = &database::singleton($_SESSION['database']['params']);
		$result = @$DB->query($sql);
		if ($result)
		{
		    common::redirect('index.php?do=2&table='.rawurlencode($_POST['tableName']), common::lang(sprintf('Created table <i>%s</i>', $_POST['tableName'])));
		}
		else
		{
		    common::redirect('index.php?do=7', common::lang(sprintf('Failed to create table, SQLite said: %s', $DB->get_last_error())));
		}
	    }
	    else common::redirect('index.php?do=7', common::lang('Either column data or table name missing!'));
	}
	$template = 'builder.tpl';
	break;
    case 8:
	if (!empty($_GET['database']))
	{
	    $_SESSION['database']['path'] = htmlspecialchars($_GET['database']);
	    $_SESSION['database']['name'] = htmlspecialchars($_GET['name']);
	    $_SESSION['database']['params'] = array('type' => 'sqlite', 'dbas' => $_SESSION['database']['path']);
	}
	$databases = sqlite::get_database_list();
	$noMaster = true;
	$template = 'left.tpl';
	break;
    case 10:
	$libVersion  = sqlite_libversion();
	$libEncoding = sqlite_libencoding();
	$phpVersion = phpversion();
	$webserver = $HTTP_SERVER_VARS["SERVER_SOFTWARE"];
	$OS = PHP_OS;
	$databases = sqlite::get_database_list();
	$template = 'right.tpl';
	break;
    case 11:
	if (empty($_SESSION['database']['name']))
	{
	    common::redirect('index.php?do=9', common::lang('No database name given!'));
	}
	if (empty($_GET['table']))
	{
	    common::redirect('index.php?do=9', common::lang('No table given!'));
	}
	else
	{
	    $tableName = htmlspecialchars($_GET['table']);
	}
	$DB = &database::singleton($_SESSION['database']['params']);
	$query = 'SELECT * FROM '.$tableName;
	$sql = $origSql = trim($query);
	$identifier = '([a-z][a-z0-9_]*|\[[a-z][a-z0-9_]*\])';
	if (!preg_match('/\s+FROM\s+[a-z]/i', $sql) OR preg_match('/(NATURAL)?\s*(LEFT|RIGHT|FULL)?\s*(OUTER|INNER|CROSS)?\s*JOIN/i', $sql) OR preg_match("/\s+FROM\s+$identifier\s*,/i", $sql) OR preg_match('/^SELECT.+\(.+FROM/Ui', $sql))
	{
	    $showEditDelete = false;
	}
	else
	{
	    preg_match("/\s+FROM\s+$identifier\s*/i", $sql, $matches);
	    $tablename = $matches[1];
	    $showEditDelete = ($tablename != 'sqlite_master' ? true : false);
	}
	if (!preg_match('/LIMIT\s+([0-9]+)(\s+OFFSET\s+([0-9])+)?$/i', $sql, $matches) AND preg_match('/^SELECT/i', $sql))
	{
	    $sql .= ' LIMIT 30 OFFSET 0';
	    $limitNumber = 30;
	    $offsetNumber = 0;
	}
	else
	{
	    $limitNumber = @$matches[1];
	    $offsetNumber = @$matches[3];
	}
	if (preg_match('/^select /i', $sql) AND $showEditDelete)
	{
	    $sql = preg_replace('/^(select) /i', '$1 _ROWID_, ', $sql);
	}
	$result = $DB->query($sql);
	$querySuccessful = is_object($result) OR $result;
	$queryHasResults = is_object($result) AND $result->num_rows() > 0;
	if ($queryHasResults)
	{
	    $resultsTable = array();
	    $headers = array();
	    while ($row = $result->fetch_row())
	    {
		$resultsRow = array();
		if (empty($headers))
		{
		    $headers = array_slice(array_keys($row), $showEditDelete ? 1 : 0);
		}
		foreach ($row as $k => $v)
		{
		    if ($k == '_ROWID_' AND empty($resultsRow) AND $showEditDelete)
		    {
			$resultsRow[] = sprintf('<nobr><a href="%s" title="%s"><span class="ui-icon ui-icon-document"></span></a> <a href="%s" title="%s" onclick="return confirm(\'%s\')"><span class="ui-icon ui-icon-trash"></span></a></nobr>', common::url("index.php?do=3&action=edit&table=$tablename&rowid=$v&redirect=".rawurlencode(common::url())), common::lang('Edit'), common::url("index.php?do=3&action=delete&table=$tablename&rowid=$v&redirect=".rawurlencode(common::url())),  common::lang('Delete'), common::lang('Are you sure you want to delete this row?'));
		    }
		    else
		    {
			$resultsRow[] = $v;
		    }
		}
		$resultsTable[] = $resultsRow;
	    }
	}
	$template = 'browse.tpl';
	break;
    case 12:
	if (!$config['authentication']['enabled'])
	{
	    common::redirect('index.php');
	}
	$_SESSION['login'] = array();
	$_SESSION['database'] = array();
	common::redirect('login.php');
	break;
    default:
	$noMaster = true;
	$template = 'frameset.tpl';
	break;
}
if (!isset($characterSet))
{
    $characterSet = common::lang('utf-8');
}
if (!isset($title))
{
    $title = 'phpSQLiteAdmin';
}
$orig_template = $template;
$template = common::getTemplate($template);
if ($template)
{
    $error_reporting = error_reporting();
    error_reporting($error_reporting & ~E_NOTICE);
    header("Content-Type: text/html; charset=$characterSet");
    if ($config['http_compression'])
    {
	ob_start('ob_gzhandler');
    }
    ob_start();
    include(!empty($noMaster) ? $template : common::getTemplate('master.tpl'));
    $contents = ob_get_contents();
    ob_end_clean();
    echo $contents;
    if ($config['http_compression'])
    {
	ob_end_flush();
    }
    error_reporting($error_reporting);
}
else
{
    die("Couldn't find template: <b>".$orig_template."</b>");
}
exit;
?>