<?php

/**
 phpSQLiteAdmin is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 phpSQLiteAdmin is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with phpSQLiteAdmin; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
 Copyright 2004 Richard Heyes
 Copyright 2006-2009 Marius Stanciu <marius.stanciu@code-purity.com>
 */

/**
 * Enter description here...
 *
 * @package		phpSQLiteAdmin
 * @author		Marius Stanciu Sergiu <marius.stanciu@code-purity.com>
 * @copyright		Copyright (c) 2006-2009, Code Purity www.code-purity.com
 * @link		http://blog.code-purity.com/pages/phpsqliteadmin
 * @since		Version 0.1.0
 */

include('config/config.php');
include($config['base_dir'].'include/initialize.php');
if (!$config['authentication']['enabled'])
{
    common::redirect('index.php');
}
if (authentication::isLoggedIn())
{
    common::redirect('index.php');
}
if (!empty($_POST))
{
    if (!empty($_POST['username']))
    {
	$auth = &authentication::factory();
	if ($auth->authenticate(htmlspecialchars($_POST['username']), htmlspecialchars($_POST['password'])))
	{
	    $_SESSION['login']['authenticated'] = true;
	    $_SESSION['login']['username'] = htmlspecialchars($_POST['username']);
	    $_SESSION['login']['sourceIP'] = common::getClientIP();
	    $_SESSION['login']['userAgent'] = $_SERVER['HTTP_USER_AGENT'];
	    $_SESSION['common']['lang'] = htmlspecialchars($_POST['language']);
	    common::redirect('index.php');
	}
	else
	{
	    common::redirect('login.php', common::lang('Invalid username/password!'));
	}
    }
    else
    {
	common::redirect('login.php', common::lang('You must supply a username!'));
    }
}
$languageList = $config['languages']['language'];
$defaultLang = !empty($_COOKIE['phpSQLiteAdmin_language']) ? htmlspecialchars($_COOKIE['phpSQLiteAdmin_language']) : $config['languages']['default'];
foreach ($languageList as $k => $v)
{
    if ($languageList[$k]['code'] == $defaultLang)
    {
	$languageList[$k]['selected'] = 'selected="selected"';
    }
}
$template = 'login.tpl';



if (!isset($characterSet))
{
    $characterSet = common::lang('utf-8');
}
if (!isset($title))
{
    $title = 'phpSQLiteAdmin';
}
$orig_template = $template;
$template = common::getTemplate($template);
if ($template)
{
    $error_reporting = error_reporting();
    error_reporting($error_reporting & ~E_NOTICE);
    header("Content-Type: text/html; charset=$characterSet");
    if ($config['http_compression'])
    {
	ob_start('ob_gzhandler');
    }
    ob_start();
    include(!empty($noMaster) ? $template : common::getTemplate('master.tpl'));
    $contents = ob_get_contents();
    ob_end_clean();
    echo $contents;
    if ($config['http_compression'])
    {
	ob_end_flush();
    }
    error_reporting($error_reporting);
}
else
{
    die("Couldn't find template: <b>".$orig_template."</b>");
}
exit;
?>