<script type="text/javascript" defer="defer">
    formObj = new form('tableBuilder');
    function constraint_onclick(constraint)
    {
	var checked = null;
	if (constraint == 'unique')
	{
	    checked = formObj.getChecked('constraint_unique');
	    formObj.setChecked('constraint_primary', false);
	    formObj.setValue('constraint', checked ? 'unique' : '');
	}
	else if (constraint == 'primary')
	{
	    checked = formObj.getChecked('constraint_primary');
	    formObj.setChecked('constraint_unique', false);
	    formObj.setValue('constraint', checked ? 'primary' : '');
	}
    }
    function clearForm()
    {
	formObj.setValue('columnName', '');
	formObj.setSelectedIndex('columnType', 0);
	formObj.setValue('columnLength', '');
	formObj.setValue('columnDefault', '');
	formObj.setChecked('null', false);
	formObj.setValue('constraint', '');
	formObj.setChecked('constraint_primary', false);
	formObj.setChecked('constraint_unique', false);
	formObj.setValue('addColumn', '<?php echo common::lang('Add Column'); ?>');
	formObj.setSelectedIndex('columnList', -1);
    }
    function addColumn_onclick()
    {
	var value = new Array();
	var text  = '';
	value[0] = formObj.getValue('columnName');
	value[1] = formObj.getValue('columnType');
	value[2] = formObj.getValue('columnLength');
	value[3] = formObj.getValue('columnDefault');
	value[4] = formObj.getValue('null');
	value[5] = formObj.getValue('constraint');
	if (value[0] == '')
	{
	    alert('<?php echo common::lang('Please enter a column name!'); ?>');
	    return false;
	}
	text += value[0];
	text += ' ' + value[1];
	if (value[2] != '') text += ' (' + value[2] + ')';
	if (value[3] != '') text += " DEFAULT '" + value[3] + "'";
	if (!value[4]) text += ' NOT NULL';
	if (value[5] == 'unique') text += ' UNIQUE';
	else if (value[5] == 'primary') text += ' PRIMARY KEY';
	value = value.join(':');
	if (formObj.numSelected('columnList') == 0) formObj.addOptionToSelect('columnList', new Option(text, value));
	else
	{
	    formObj.setSelectedOptionValue('columnList', value);
	    formObj.setSelectedOptionText('columnList', text);
	    formObj.setSelectedIndex('columnList', -1);
	}
	clearForm();
    }
    function removeColumn_onclick()
    {
	formObj.getSelectedIndex('columnList');
	if (formObj.numSelected('columnList') == 1) formObj.removeOptionFromSelect('columnList', formObj.getSelectedIndex('columnList'));
	clearForm();
	return false;
    }
    function columnList_onchange(selectObj)
    {
	var value = formObj.getValue('columnList');
	value = value.split(':');
	formObj.setValue('addColumn', '<?php echo common::lang('Update Column'); ?>');
	formObj.setValue('columnName', value[0]);
	formObj.setValue('columnType', value[1]);
	formObj.setValue('columnLength', value[2]);
	formObj.setValue('columnDefault', value[3]);
	formObj.setChecked('null', value[4] == '1');
	formObj.setValue('constraint', value[5]);
	formObj.setChecked('constraint_primary', value[5] == 'primary');
	formObj.setChecked('constraint_unique', value[5] == 'unique');
    }
    function moveUp_onclick()
    {
	var selectedIndex = formObj.getSelectedIndex('columnList');
	if (selectedIndex > 0)
	{
	    formObj.swapOptions('columnList', selectedIndex, selectedIndex - 1);
	    formObj.setSelectedIndex('columnList', selectedIndex - 1);
	}
    }
    function moveDown_onclick()
    {
	var selectedIndex = formObj.getSelectedIndex('columnList');
	if (selectedIndex < (formObj.elements['columnList'].options.length - 1))
	{
	    formObj.swapOptions('columnList', selectedIndex, selectedIndex + 1);
	    formObj.setSelectedIndex('columnList', selectedIndex + 1);
	}
    }
    function addTable_onclick()
    {
	if (formObj.numOptions('columnList') == 0)
	{
	    alert('<?php echo common::lang('You must specify some columns!'); ?>');
	    return false;
	}
	if (formObj.getValue('tableName').replace(/\s+/, '') == '')
	{
	    alert('<?php echo common::lang('Please enter a table name!'); ?>');
	    return false;
	}
	var columns = new Array();
	var columnListOptions = formObj.elements['columnList'].options;
	for (var i=0; i<columnListOptions.length; ++i) columns[columns.length] = columnListOptions[i].value;
	formObj.setValue('columns', columns.join('|'));
    }
</script>
<div style="margin-bottom:20px; padding: 5px; width: 25%" class="ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix"><?php echo common::lang('Table Builder'); ?></div>
<div id="main">
    <form name="tableBuilder" method="post" action="<?php echo common::url('index.php?do=7'); ?>">
	<input type="hidden" name="columns" value="" />
	<input type="hidden" name="constraint" value="" />
	<table border="0">
	    <tr>
		<td colspan="2" width="100%">
		    <fieldset>
			<legend><b><?php echo common::lang('Column List'); ?></b></legend>
			<table>
			    <tr>
				<td>
				    <select name="columnList" size="10" style="width: 500px;background-color:#EEEEEE; border:1px solid #AAAAAA; padding:3px;" onchange="columnList_onchange(this)"></select>
				</td>
				<td valign="center">
				    <button class="button ui-corner-all" onclick="moveUp_onclick(); return false"><img src="images/arrow.up.gif" width="16" height="8" alt="<?php echo common::lang(' Move up')?>" vspace="4" /></button>
				    <br /><br />
				    <button class="button ui-corner-all" onclick="moveDown_onclick(); return false"><img src="images/arrow.down.gif" width="16" height="8" alt="<?php echo common::lang(' Move down'); ?>" vspace="4" /></button>
				</td>
			    </tr>
			</table>
		    </fieldset>
		</td>
	    </tr>
	    <tr>
		<td align="center" style="padding-top:20px;">
		    <button style="width: 45%" name="addColumn" class="button ui-corner-all" onclick="addColumn_onclick(); return false"><?php echo common::lang('Add Column'); ?></button>&nbsp;&nbsp;<button style="width: 45%" name="removeColumn" class="button ui-corner-all" onclick="removeColumn_onclick(); return false"><?php echo common::lang('Remove Column'); ?></button>
		</td>
		<td rowspan="4">&nbsp;</td>
	    </tr>
	    <tr>
		<td>&nbsp;</td>
	    </tr>
	    <tr>
		<td>
		    <fieldset>
			<legend><b><?php echo common::lang('Column Properties'); ?></b></legend>
			<table border="0">
			    <tr>
				<td><?php echo common::lang('Column Name:'); ?></td>
				<td colspan="2">
				    <input class="textbox" type="text" name="columnName" value="" />
				</td>
			    </tr>
			    <tr>
				<td><?php echo common::lang('Column Type:'); ?></td>
				<td>
				    <select style="background-color:#EEEEEE; border: 1px solid #aaa; padding: 3px" name="columnType">
					<optgroup label="<?php echo common::lang('Textual Types'); ?>">
					    <option value="varchar">VARCHAR</option>
					    <option value="char">CHAR</option>
					    <option value="text">TEXT</option>
					    <option value="clob">CLOB</option>
					    <option value="blob">BLOB</option>
					</optgroup>
					<optgroup label="<?php echo common::lang('Numeric Types'); ?>">
					    <option value="integer">INTEGER</option>
					    <option value="mediumint">MEDIUMINT</option>
					    <option value="smallint">SMALLINT</option>
					    <option value="tinyint">TINYINT</option>
					    <option value="float">FLOAT</option>
					    <option value="numeric">NUMERIC</option>
					    <option value="decimal">DECIMAL</option>
					</optgroup>
					<optgroup label="<?php echo common::lang('Date/Time Types'); ?>">
					    <option value="datetime">DATETIME</option>
					    <option value="datetime">DATE</option>
					    <option value="timestamp">TIMESTAMP</option>
					</optgroup>
					<optgroup label="<?php echo common::lang('Other Types'); ?>">
					    <option value="boolean">BOOLEAN</option>
					</optgroup>
				    </select>
				</td>
				<td><input type="text" class="textbox" value="" size="3" name="columnLength" /> <?php echo common::lang('(Note: SQLite is <a href="http://www.sqlite.org/datatypes.html" target="_blank">typeless</a>!)'); ?></td>
			    </tr>
			    <tr>
				<td><?php echo common::lang('Default Value:'); ?></td>
				<td colspan="2">
				    <input type="text" class="textbox" name="columnDefault" value="" />
				</td>
			    </tr>
			    <tr>
				<td>&nbsp;</td>
				<td colspan="2">
				    <input type="checkbox" name="null" value="1" id="null" /> <label for="null"><?php echo common::lang('Null'); ?></label>
				</td>
			    </tr>
			    <tr>
				<td>&nbsp;</td>
				<td colspan="2">
				    <input type="checkbox" name="constraint_primary" value="primary" id="constraint_primary" onclick="constraint_onclick('primary')" /> <label for="constraint_primary"><?php echo common::lang('Primary Key'); ?></label>
				</td>
			    </tr>
			    <tr>
				<td>&nbsp;</td>
				<td colspan="2">
				    <input type="checkbox" name="constraint_unique" value="unique" id="constraint_unique" onclick="constraint_onclick('unique')" /> <label for="constraint_unique"><?php echo common::lang('Unique'); ?></label>
				</td>
			    </tr>

			</table>
		    </fieldset>
		</td>
	    </tr>
	    <tr>
		<td align="right" style="padding-top:20px;">
		    <button class="button ui-corner-all" onclick="clearForm(); return false"><?php echo common::lang('Clear') ?></button>
		</td>
	    </tr>
	    <tr>
		<td>
		    <fieldset>
			<legend><b><?php echo common::lang('Table Properties'); ?></b></legend>
			<table border="0">
			    <tr>
				<td><?php echo common::lang('Table Name:'); ?></td>
				<td>
				    <input type="text" class="textbox" name="tableName" value="" />
				</td>
			    </tr>
			    <tr>
				<td>&nbsp;</td>
				<td>
				    <input type="checkbox" name="temporary" value="1" id="temporary" /><label for="temporary"><?php echo common::lang('Temporary'); ?></label>
				</td>
			    </tr>
			</table>
		    </fieldset>
		</td>
	    </tr>
	    <tr>
		<td align="right" style="padding-top:20px;">
		    <input type="submit" class="button ui-corner-all" value="<?php echo common::lang('Add Table'); ?>" onclick="return addTable_onclick()" />
		</td>
	    </tr>
	</table>
    </form>
</div>