<div id="newtabs">
    <ul>
	<li><a href="#tabs-1"><?php echo common::lang('Properties'); ?></a></li>
	<li><a href="#tabs-2"><?php echo common::lang('Tables'); ?></a></li>
	<li><a href="#tabs-3"><?php echo common::lang('Views'); ?></a></li>
    </ul>
    <div id="tabs-1">
	<table border="0" style="width:100%" class="results">
	    <tr>
		<th><?php echo common::lang('Property') ?></th>
		<th><?php echo common::lang('Value') ?></th>
	    </tr>
	    <tr>
		<td><?php echo common::lang('Full Path') ?></td>
		<td><?php echo realpath($_SESSION['database']['path']) ?></td>
	    </tr>
	    <tr>
		<td><?php echo common::lang('Size') ?></td>
		<td><?php echo common::formatFilesize(filesize($_SESSION['database']['path'])) ?></td>
	    </tr>
	    <tr>
		<td><?php echo common::lang('Last Modified') ?></td>
		<td><?php echo date('H:i:s jS F Y', $filemtime)." ($xDaysAgo)" ?></td>
	    </tr>
	    <?php
	    if (function_exists(posix_getpwuid))
	    {
		$ownerProperties = posix_getpwuid(fileowner($_SESSION['database']['path']));
		?>
	    <tr>
		<td><?php echo common::lang('Owner') ?></td>
		<td><?php echo $ownerProperties['name'] ?></td>
	    </tr>
	    <?php
	    }
	    ?>
	</table>
    </div>
    <div id="tabs-2">
	<table border="0" style="width:100%" class="results">
	    <tr>
		<th class="actions">&nbsp;</th>
		<th><?php echo common::lang('Table Name'); ?></th>
		<th class="numeric"><?php echo common::lang('Records'); ?></th>
	    </tr>
	    <?php
	    foreach($tables as $k => $t)
	    {
		?>
	    <tr>
		<td>
		    <a title="<?php echo common::lang('Properties'); ?>" href="<?php echo common::url('table.php?table='.rawurlencode($t['name'])); ?>"><span class="ui-icon ui-icon-document"></span></a>
		    <a title="<?php echo common::lang('Browse'); ?>" href="<?php echo common::url('query.php?action=browse&table='.$t['name']); ?>"><span class="ui-icon ui-icon-search"></span></a>
		    <a title="<?php echo common::lang('Query'); ?>" href="<?php echo common::url('query.php?table='.rawurlencode($t['name'])); ?>"><span class="ui-icon ui-icon-comment"></span></a>
		    <a title="<?php echo common::lang('Insert'); ?>" href="<?php echo common::url('row.php?action=insert&table='.rawurlencode($t['name']).'&redirect=database.php'); ?>"><span class="ui-icon ui-icon-image"></span></a>
		    <a title="<?php echo common::lang('Empty'); ?>" href="<?php echo common::url('table.php?action=empty&table='.rawurlencode($t['name'])); ?>" onclick="return confirm('<?php echo common::javascriptEscapeString(common::lang('Are you sure you want to delete all rows from this table?')); ?>')"><span class="ui-icon ui-icon-closethick"></span></a>
		    <a title="<?php echo common::lang('Drop'); ?>" href="<?php echo common::url('table.php?action=drop&table='.rawurlencode($t['name'])); ?>" onclick="return confirm('<?php echo common::javascriptEscapeString(common::lang('Are you sure you want to drop this table?')); ?>')"><span class="ui-icon ui-icon-trash"></span></a>
		</td>
		<td>
		    <a href="<?php echo common::url('table.php?table='.rawurlencode($t['name'])); ?>"><?php echo $t['name']; ?></a>
		</td>
		<td><?php echo $t['records']; ?></td>
	    </tr>
		<?php
		$tableRecords += $t['records'];
	    }
	    ?>
	    <tr>
		<th>&nbsp;</th>
		<th class="summary"><?php echo count($tables).common::lang(' table(s)'); ?></th>
		<th class="summary"><?php echo $tableRecords; ?></th>
	    </tr>
	</table>
    </div>
    <div id="tabs-3">
	<table border="0" style="width:100%" class="results">
	    <tr>
		<th class="actions">&nbsp;</th>
		<th><?php echo common::lang('View SQL'); ?></th>
		<th><?php echo common::lang('View Name'); ?></th>
	    </tr>
	    <?php
	    foreach($views as $k => $v)
	    {
		?>
	    <tr>
		<td>
		    <a title="<?php echo common::lang('View'); ?>" href="<?php echo common::url('query.php?sql='.rawurlencode('SELECT * FROM ' . $v['name'])); ?>"><span class="ui-icon ui-icon-document"></span></a>
		    <a title="<?php echo common::lang('Edit'); ?>" href="<?php echo common::url('view.php?action=edit&view='.$v['name']); ?>"><span class="ui-icon ui-icon-folder"></span></a>
		    <a title="<?php echo common::lang('Drop'); ?>" href="<?php echo common::url('view.php?action=drop&view='.$v['name']); ?>" onclick="return confirm('<?php echo common::javascriptEscapeString(common::lang('Are you sure you want to drop this view?')); ?>')"><span class="ui-icon ui-icon-trash"></span></a>
		</td>
		<td><?php echo common::truncateText($v['sql'], 50); ?></td>
		<td><?php echo $v['name']; ?></td>
	    </tr>
	    <?php
	    }
	    ?>
	    <tr>
		<th>&nbsp;</th>
		<th>&nbsp;</th>
		<th class="summary"><?php echo count($views).common::lang(' view(s)'); ?></th>
	    </tr>
	</table>
    </div>
</div>