<script type="text/javascript" defer="defer">
    formObj = new form('rowForm');
    function nullifyInput(checkObj, columnName)
    {
	if (checkObj.checked)
	{
	    formObj.setDisabled('rowData[' + columnName + ']', true);
	    formObj.setDisabled('functions[' + columnName + ']', true);
	    formObj.elements['rowData[' + columnName + ']'].className = 'disabled';
	    formObj.elements['functions[' + columnName + ']'].className = 'disabled';
	}
	else
	{
	    formObj.setDisabled('rowData[' + columnName + ']', false);
	    formObj.setDisabled('functions[' + columnName + ']', false);
	    formObj.elements['rowData[' + columnName + ']'].className = '';
	    formObj.elements['functions[' + columnName + ']'].className = '';
	}
    }
</script>
<div style="margin-bottom:20px; padding: 5px; width: 25%" class="ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix"><?php echo $pageTitle; ?> <i><?php echo $tableName; ?></i></div>
<?php echo common::generateMenu($tableName, 4) ?>
<div id="main">
    <form action="<?php echo common::url('index.php?do=3&action='.$formAction.'&table='.rawurlencode($tableName)."&rowid=$rowID"); ?>" method="post" name="rowForm">
	<input type="hidden" name="redirect" value="<?php echo $_GET['redirect']; ?>" />
	<table border="0" style="width:100%" class="results">
	    <tr>
		<th><?php echo common::lang('Field'); ?></th>
		<th><?php echo common::lang('Type'); ?></th>
		<th style="width:120px"><?php echo common::lang('Function'); ?></th>
		<th class="numeric"><?php echo common::lang('Null'); ?></th>
		<th style="width:120px"><?php echo common::lang('Value'); ?></th>
	    </tr>
	    <?php
	    foreach($tableStructure as $t)
	    {
		?>
	    <tr>
		<td><?php echo $t['name']; ?></td>
		<td><?php echo $t['type']; ?></td>
		<td>
		    <select style="background-color:#EEEEEE;border: 1px solid #aaa;padding: 3px" name="functions[<?php echo $t['name']; ?>]" <?php if($t['autoincrement'] AND $isInsert): ?>disabled="disabled" class="disabled"<?php endif ?> >
			<option value=""></option>
			<optgroup label="<?php echo common::lang('SQLite Functions'); ?>">
			    <option value="sqlite:abs">ABS</option>
			    <option value="sqlite:date">DATE</option>
			    <option value="sqlite:datetime">DATETIME</option>
			    <option value="sqlite:last_insert_rowid">LAST_INSERT_ROWID</option>
			    <option value="sqlite:length">LENGTH</option>
			    <option value="sqlite:lower">LOWER</option>
			    <option value="sqlite:random">RANDOM</option>
			    <option value="sqlite:round">ROUND</option>
			    <option value="sqlite:soundex">SOUNDEX</option>
			    <option value="sqlite:sqlite_version">SQLITE_VERSION</option>
			    <option value="sqlite:upper">UPPER</option>
			</optgroup>
			<optgroup label="<?php echo common::lang('PHP Functions'); ?>">
			    <option value="php:md5">MD5</option>
			</optgroup>
			<optgroup label="<?php echo common::lang('User Functions'); ?>">
				<?php
				foreach($userFunctions as $f)
				{
				    ?>
			    <option value="sqlite:<?php echo $f['actual']; ?>"><?php echo strtoupper($f['friendly']); ?></option>
				<?php
				}
				?>
			</optgroup>
		    </select>
		</td>
		<td><?php echo ($t['notnull'] ? '' : "<input type=\"checkbox\" value=\"1\" name=\"null[$t[name]]\" onclick=\"nullifyInput(this, '".common::javascriptEscapeString($t['name']) . "')\"/>"); ?></td>
		<td>
		    <input type="text" class="textbox" value="<?php echo $rowData[$t['name']]; ?>" name="rowData[<?php echo $t['name']; ?>]" <?php if($t['autoincrement'] AND $isInsert):?>disabled="disabled" class="disabled"<?php endif; ?> />
		</td>
	    </tr>
	    <?php
	    }
	    ?>
	    <tr>
		<th colspan="5" align="right">
		    <table border="0">
			<tr>
			    <td><input type="radio" name="redirectType" value="return" id="redirectType_return" checked="checked" /> <label for="redirectType_return"><?php echo common::lang('Return to previous page'); ?></label></td>
			</tr>
			<tr>
			    <td><input type="radio" name="redirectType" value="insert" id="redirectType_insert" /> <label for="redirectType_insert"><?php echo common::lang('Insert another row'); ?></label></td>
			</tr>
		    </table>
		</th>
	    </tr>
	    <tr>
		<th colspan="5" align="right">
		    <input class="button ui-corner-all" type="submit" value="<?php echo $submitLabel; ?>" />
		</th>
	    </tr>
	</table>
    </form>
</div>