<?php

namespace framework;

use framework\route\Route;
use framework\route\Driver as RouteDriver;
use framework\Exception;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * Application
 */
class Application {

    public static $_routeSreach = null;
    public static $_version = '1.0.0';

    /**
     * run
     */
    public static function run($argv = []) {
        date_default_timezone_set('Asia/Shanghai');
        header("Content-type: text/html; charset=utf-8");
        error_reporting(0);
        require_once $GLOBALS['app']['root_path'] . '/framework/function.php';
        spl_autoload_register(function($classname) {
            $filename = rootPath() . '/' . str_replace("\\", "/", $classname) . '.php';
            if (file_exists($filename)) {
                include_once($filename);
            }
        });
        return static::runContext();
    }

    /**
     * runContext
     * @return type
     * @throws Exception
     */
    public static function runContext() {
        foreach (glob(appPath() . '/function/*.php') as $file) {
            require_once $file;
        }
        register_shutdown_function(function() {
            return Exception::fastCgiCatchError();
        });
        $container = null;
        try {
            RouteDriver::driverReady();
            static::$_routeSreach = Route::search(filter_input(INPUT_SERVER, 'REQUEST_URI'));
            if (static::$_routeSreach == null) {
                if(configSystem('config.debug', false) == true){
                    throw new Exception('系统错误：Application::run 未找到有效路由');
                }
                return Header::header404();
            }
            unset($GLOBALS['app']['route']);
            static::callBeforeMiddleware();
            $container = static::callContainer();
            static::callAfterMiddleware();
        } catch (Exception $ex) {
            $container = $ex->output();
            if (configSystem('config.debug', false) == false) {
                return Header::header500();
            }
        }
        return View::output($container);
    }

    /**
     * callContainer
     * @return type
     */
    public static function callContainer() {
        $appController = new static::$_routeSreach['controller'];
        $paramMethod = static::$_routeSreach['method'];
        if (!is_object($appController)) {
            throw new Exception('系统错误：Application::run 控制器对象为空 ' . static::$_routeSreach['controller']);
        }
        if (!method_exists($appController, static::$_routeSreach['method'])) {
            throw new Exception('系统错误：Application::run 不存在的方法 ' . static::$_routeSreach['controller'] . '->' . $paramMethod);
        }
        return call_user_func_array([$appController, static::$_routeSreach['method']], static::$_routeSreach['paramter']);
    }

    /**
     * callBeforeMiddleware
     * @return type
     */
    public static function callBeforeMiddleware() {
        $beforeMiddleware = new static::$_routeSreach['beforeMiddleware'];
        if ($beforeMiddleware->context(static::$_routeSreach['paramter'][0]) == false) {
            return View::output(null);
        }
    }

    /**
     * callAfterMiddleware
     * @return type
     */
    public static function callAfterMiddleware() {
        $afterMiddleware = new static::$_routeSreach['afterMiddleware'];
        if ($afterMiddleware->context(static::$_routeSreach['paramter'][0]) == false) {
            return View::output(null);
        }
    }

}
