<?php

namespace framework;

use framework\Exception;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * View
 */
class View {

    /**
     * h5
     * @param type $template
     * @param type $assign
     * @return type
     */
    public static function base($template, $assign = []) {
        $tplpath = static::createTemplatePath('base.' . $template);
        return View::create($tplpath, $assign);
    }

    /**
     * develop
     * @param type $template
     * @param type $assign
     * @return type
     */
    public static function develop($template, $assign = []) {
        $tplpath = static::createTemplatePath('develop.' . $template);
        return View::create($tplpath, $assign);
    }

    /**
     * framework
     * @param type $template
     * @param type $assign
     * @return type
     */
    public static function framework($template, $assign = []) {
        $template = ".framework.output.{$template}";
        $tplpath = rootPath() . str_replace('.', '/', ($template)) . '.php';
        return View::create($tplpath, $assign);
    }

    /**
     * createTemplatePath
     * @param type $templateDir
     * @param type $template
     * @return type
     */
    public static function createTemplatePath($template) {
        $template = ".shangfan.view.{$template}";
        return rootPath() . str_replace('.', '/', ($template)) . '.php';
    }

    /**
     * make
     * @param type $template
     * @param type $assign
     * @throws Exception
     */
    public static function make($template, $assign = []) {
        $tplpath = View::createTemplatePath($template);
        return View::create($tplpath, $assign);
    }

    /**
     * create
     * @param type $tplpath
     * @param type $assign
     * @throws Exception
     */
    public static function create($tplpath, $assign = []) {
        if (!file_exists($tplpath)) {
            throw new Exception('framework错误： 模板不存在' . $tplpath);
        }
        if (count($assign)) {
            extract($assign);
        }
        require_once $tplpath;
        return "\n";
    }

    /**
     * output
     * @param type $container
     * @return type
     */
    public static function output($container) {
        return file_put_contents('php://output', $container);
    }

}
