<?php

namespace framework\database;

use framework\Exception;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * Database
 */
class Database {

    private $db_host;
    private $db_port;
    private $db_database;
    private $db_username;
    private $db_password;
    private $db_charset;
    private $conn;
    private $result;
    private $sql;
    private $modelClass;
    private static $instance;

    /**
     * __construct
     */
    public function __construct($param = array()) {
        $this->db_host = configSystem('config.db.host');
        $this->db_port = configSystem('config.db.port');
        $this->db_database = configSystem('config.db.database');
        $this->db_username = configSystem('config.db.user');
        $this->db_password = configSystem('config.db.password');
        $this->db_charset = configSystem('config.db.charset');
        foreach ($param as $key => $val) {
            $this->$key = $val;
        }
    }

    /**
     * getInstance
     * @return type
     */
    public static function getInstance($param = array(), $create = false) {
        if ($create == true) {
            return new static($param);
        } else {
            static::$instance = new static($param);
        }
        return static::$instance;
    }

    /**
     * connect
     */
    public function connect() {
        $this->conn = mysqli_connect($this->db_host, $this->db_username, $this->db_password, $this->db_database, $this->db_port);
        
        if (!$this->conn) {
            throw new Exception('\framework\database\Database错误：数据库连接失败 ', $this->db_database);
        }
        if (!mysqli_select_db($this->conn, $this->db_database)) {
            throw new Exception('\framework\database\Database错误：数据库不可用 ', $this->db_database);
        }
        mysqli_query($this->conn, "SET NAMES utf8");
        return $this->conn;
    }

    /**
     * first
     * @param type $sql
     * @return type
     */
    public function first($sql = '', $debug = false) {
        if ($debug) {
            dd(date('Y/m/d H:i:s') . ' debug调试：' . $this->buildSql($sql));
        }
        $result = mysqli_query($this->connect(), $this->buildSql($sql), MYSQLI_STORE_RESULT);
        if ($result) {
            $fetch = $result->fetch_array(MYSQLI_ASSOC);
            if (count($fetch)) {
                return $this->modelClass ? new $this->modelClass($fetch) : $fetch;
            }
        }
        return null;
    }

    /**
     * get
     * @param type $sql
     */
    public function get($sql = '', $isArray = false, $debug = false) {
        if ($debug) {
            dd(date('Y/m/d H:i:s') . ' debug调试：' . $this->buildSql($sql));
        }
        $result = mysqli_query($this->connect(), $this->buildSql($sql), MYSQLI_STORE_RESULT);
        $allRows = array();
        while (($rows = $result->fetch_array(MYSQLI_ASSOC))) {
            if (!$rows) {
                continue;
            }
            if ($isArray) {
                $allRows[] = $rows;
                continue;
            }
            $allRows[] = $this->modelClass ? new $this->modelClass($rows) : $rows;
        }
        return $allRows;
    }

    /**
     * count
     * @return type
     */
    public function count($sql = '') {
        $results = $this->first($sql);
        if (!$results) {
            return 0;
        }
        return (int) $results->count;
    }

    /**
     * sum
     * @param type $sql
     * @return int
     */
    public function sum($sql = '') {
        $results = $this->first($sql);
        if (!$results) {
            return 0;
        }
        return (int) $results->sum;
    }

    /**
     * insert
     * @param type $array
     * @param type $debug
     * @return type
     */
    public function insert($array, $debug = false) {
        if (!$this->modelClass) {
            throw new Exception('\framework\database\Database错误：insert需指定映射类名');
        }
        $modelClass = new $this->modelClass();
        if (!isset($modelClass->table)) {
            throw new Exception('\framework\database\Database错误：insert需指定映射table');
        }
        if (!isset($modelClass->key)) {
            throw new Exception('\framework\database\Database错误：insert需指定映射key');
        }
        if (!count($array)) {
            throw new Exception('\framework\database\Database错误：insert需指定参数为数组');
        }
        $into = array();
        $values = array();
        foreach ($array as $key => $val) {
            $into[] = '`' . $key . '`';
            $values[] = '\'' . $val . '\'';
        }
        $intoStr = '(' . implode(',', $into) . ')';
        $valuesStr = '(' . implode(',', $values) . ')';
        $sql = 'insert into ' . $modelClass->table . ' ' . $intoStr . ' values ' . $valuesStr . ';';
        if ($debug) {
            dd(date('Y/m/d H:i:s') . ' debug调试：' . $this->buildSql($sql));
        }
        unset($modelClass, $into, $values, $intoStr, $valuesStr);
        if (!mysqli_query($this->connect(), $this->buildSql($sql))) {
            return 0;
        }
        return mysqli_insert_id($this->conn);
    }

    /**
     * buildSql
     * @param type $sql
     * @return type
     */
    public function buildSql($sql) {
        $modelClass = null;
        try {
            $modelClass = new $this->modelClass();
        } catch (Exception $ex) {
            return $sql;
        }
        if (!$modelClass) {
            return $sql;
        }
        return str_replace("{table}", $modelClass->table, $sql);
    }

    /**
     * update
     * @param type $sql
     * @param type $debug
     * @return type
     */
    public function update($sql = '', $debug = false) {
        if ($debug) {
            throw new Exception($this->buildSql($sql));
        }
        if (!mysqli_query($this->connect(), $this->buildSql($sql))) {
            return 0;
        }
        return mysqli_affected_rows($this->conn);
    }

}
