<?php

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 */
if (!function_exists('statusSuccess')) {

    function statusSuccess($message = 'success', $data = []) {
        return [
            'status' => 1,
            'message' => $message,
            'data' => $data
        ];
    }

}

if (!function_exists('statusFailure')) {

    function statusFailure($message = 'failure', $data = []) {
        return [
            'status' => 0,
            'message' => $message,
            'data' => $data
        ];
    }

}

if (!function_exists('dd')) {

    function dd($var) {
        if ($var === null) {
            exit('null');
        }
        if (is_bool($var)) {
            if ($var == true) {
                exit('true');
            } else {
                exit('false');
            }
        }
        echo '<pre>';
        print_r($var);
        echo '</pre>';
        exit();
    }

}

if (!function_exists('used')) {

    function used($use) {
        eval("use $use;");
        $filename = rootPath() . '/' . str_replace("\\", "/", $use) . '.php';
        if (file_exists($filename)) {
            include_once($filename);
        }
    }

}

if (!function_exists('rootPath')) {

    function rootPath() {
        return $GLOBALS['app']['root_path'];
    }

}

if (!function_exists('frameworkPath')) {

    function frameworkPath() {
        return rootPath() . '/framework';
    }

}

if (!function_exists('appPath')) {

    function appPath() {
        return rootPath() . '/shangfan';
    }

}

if (!function_exists('consolePath')) {

    function consolePath() {
        return rootPath() . '/console';
    }

}

if (!function_exists('libraryPath')) {

    function libraryPath() {
        return rootPath() . '/library';
    }

}
if (!function_exists('viewPath')) {

    function viewPath() {
        return rootPath() . '/view';
    }

}

if (!function_exists('publicPath')) {

    function publicPath() {
        return rootPath() . '/public';
    }

}

if (!function_exists('storagePath')) {

    function storagePath() {
        return rootPath() . '/storage';
    }

}

if (!function_exists('rootDomain')) {

    function rootDomain() {
        return $_SERVER['HTTP_HOST'];
    }

}

if (!function_exists('httpDomain')) {

    function httpDomain() {
        if (array_key_exists('HTTPS', $_SERVER) && $_SERVER['HTTPS'] == 'on') {
            return 'https://' . rootDomain();
        }
        return 'http://' . rootDomain();
    }

}

if (!function_exists('view')) {

    function view($template, $assign = []) {
        return \framework\View::make($template, $assign);
    }

}

if (!function_exists('config')) {

    function config($path, $default = null) {
        return \framework\config\Config::make($path, $default);
    }

}

if (!function_exists('configSystem')) {

    function configSystem($path, $default = '') {
        return \framework\config\Config::make($path, $default, true);
    }

}

if (!function_exists('value')) {

    function value($value) {
        return $value instanceof Closure ? $value() : $value;
    }

}

if (!function_exists('url')) {

    function url($url) {
        return str_replace('{dir}', configSystem('config.adminDirectory'), $url);
    }

}

if (!function_exists('urlAdmin')) {

    function urlAdmin($url) {
        return '/' . adminDirectory() . $url;
    }

}

if (!function_exists('adminDirectory')) {

    function adminDirectory() {
        return configSystem('config.adminDirectory');
    }

}

if (!function_exists('resource')) {

    function resource($path) {
        if (!file_exists(rootPath() . '/shangfan/view' . $path)) {
            return 'file not exists';
        }
        return '/shangfan/view' . $path;
    }

}
if (!function_exists('pic')) {

    function pic($path) {
        return '/shangfan/view' . $path;
    }

}
if (!function_exists('picPublic')) {

    function picPublic($path) {
        if (!file_exists(rootPath() . $path) || !$path) {
            return '/shangfan/view/base/web/public/img/shangfan_pic_404.png';
        }
        return $path;
    }

}
if (!function_exists('version')) {

    function version() {
        return 'v' . \framework\Application::$_version;
    }

}

if (!function_exists('urlp')) {

    function urlp($domain, $url) {
        return \framework\Request::httpsPrefix() . $domain . $url;
    }

}

if (!function_exists('setTitle')) {

    function setTitle($title, $keywords = '', $description = '') {
        \framework\Response::setMenuTitle($title);
        headerTitle($title);
    }

}

if (!function_exists('headerTitle')) {

    function headerTitle($title, $keywords = '', $description = '') {
        \framework\Response::setSeoTitle($title);
        \framework\Response::setSeoKeywords($keywords ? $keywords : $title);
        \framework\Response::setSeoDescription($description ? $description : $title);
    }

}

if (!function_exists('menuSelect')) {

    function menuSelect($url) {
        return \framework\Route::datail('route') == $url;
    }

}

/**
 * msubstr
 */
if (!function_exists('msubstr')) {

    function msubstr($str, $start = 0, $length, $charset = "utf-8", $suffix = '…') {
        $suffix = (mb_strlen($str, $charset) > $length) ? $suffix : '';
        if (function_exists("mb_substr"))
            return mb_substr($str, $start, $length, $charset) . $suffix;
        elseif (function_exists('iconv_substr')) {
            return iconv_substr($str, $start, $length, $charset) . $suffix;
        }
        $re ['utf-8'] = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
        $re ['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
        $re ['gbk'] = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
        $re ['big5'] = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
        preg_match_all($re [$charset], $str, $match);
        $slice = join("", array_slice($match [0], $start, $length));
        if ($suffix)
            return $slice . "…";
        return $slice;
    }

}

if (!function_exists('stringWhereIn')) {

    function stringWhereIn($arr = []) {
        if (!is_array($arr) || !count($arr)) {
            return "";
        }
        $arr = array_unique($arr);
        $string = [];
        foreach ($arr as $val) {
            $string[] = "'{$val}'";
        }
        return implode(',', $string);
    }

}

if (!function_exists('random')) {

    function random($start, $end, $lenth = 1) {
        $str = '';
        for ($i = 1; $i <= $lenth; $i++) {
            $str .= rand($start, $end);
        }
        return $str;
    }

}

if (!function_exists('urlFliter')) {

    function urlFliter($url) {
        if (substr($url, 0, 7) == 'http://') {
            return true;
        }
        if (substr($url, 0, 8) == 'https://') {
            return true;
        }
        return false;
    }

}

if (!function_exists('headerHttpStatus')) {

    function headerHttpStatus($url) {
        $header = get_headers($url);
        if ($header == false || !is_array($header) || !count($header)) {
            return 0;
        }
        $conf = explode(' ', $header[0]);
        if (!is_array($conf) || count($conf) < 2) {
            return 0;
        }
        return intval(trim($conf[1]));
    }

}

if (!function_exists('isWeixin')) {

    function isWeixin() {
        if (strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') !== false) {
            return true;
        } return false;
    }

}

if (!function_exists('ch2arr')) {

    function ch2arr($str) {
        $length = mb_strlen($str, 'utf-8');
        $array = [];
        for ($i = 0; $i < $length; $i++)
            $array[] = mb_substr($str, $i, 1, 'utf-8');
        return $array;
    }

}

if (!function_exists('sqlWhrerInStringBuild')) {

    function sqlWhrerInStringBuild(array $conf) {
        if (!is_array($conf) || !count($conf)) {
            throw new \framework\Exception('function sqlWhrerInStringBuild() 参数有误');
        }
        $whereInString = [];
        foreach ($conf as $val) {
            $whereInString[] = '\'' . $val . '\'';
        }
        return implode(',', $whereInString);
    }

}

if (!function_exists('stringPhoneReplace')) {

    function stringPhoneReplace($string) {
        return substr_replace($string, '****', 3, 4);
    }

}

if (!function_exists('qrcodeCreate')) {

    function qrcodeCreate($string, $size = 10) {
        require_once libraryPath() . '/phpqrcode/phpqrcode.php';
        return QRcode::png($string, false, QR_ECLEVEL_L, $size);
    }

}

if (!function_exists('createMd5')) {

    function createMd5($createId) {
        return md5(substr(md5(adminDirectory()), 0, 16) . $createId);
    }

}

if (!function_exists('systemConfig')) {

    function systemConfig($confKey, $defaultValue = '') {
        $systemConfig = framework\config\SystemConfig::get($confKey);
        return $systemConfig && $systemConfig->conf_value != '' ? $systemConfig->conf_value : $defaultValue;
    }

}

