<?php

namespace framework\log;

use framework\file\File;

/**
 * Paylog
 * @author df
 */
class PayLog {

    /**
     * createAlif2f
     * @param type $log
     * @return type
     */
    public static function createAlif2f($log) {
        $filepath = '/storage/log/pay/alif2f/' . date('Ymd') . '.log';
        return PayLog::make($filepath, $log);
    }

    /**
     * createWxpayment
     * @param type $log
     * @return type
     */
    public static function createWxpayment($log) {
        $filepath = '/storage/log/pay/wxpayment/' . date('Ymd') . '.log';
        return PayLog::make($filepath, $log);
    }

    /**
     * make
     * @param type $log
     * @return type
     */
    public static function make($filepath, $log) {
        $log = date('Y/m/d H:i:s') . ' ' . $log;
        $success = File::makeDirectory(dirname($filepath));
        if (!$success['status']) {
            return $success;
        }
        $success = File::makeTouch($filepath);
        if (!$success['status']) {
            return $success;
        }
        $success = File::write($filepath, $log);
        if (!$success) {
            return statusFailure('追加支付日志失败');
        }
        return statusSuccess();
    }

}
