<?php

namespace framework\session;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * Session
 */
class Session {

    /**
     * set
     * @param type $key
     * @param type $val
     * @return type
     */
    public static function set($key, $val) {
        $_SESSION[$key] = $val;
        return array_key_exists($key, $_SESSION);
    }

    /**
     * get
     * @param type $key
     * @return null
     */
    public static function get($key) {
        if (array_key_exists($key, $_SESSION)) {
            return $_SESSION[$key];
        }
        return null;
    }

    /**
     * getSessId
     * @return type
     */
    public static function getSessId() {
        return null;
    }

    /**
     * $key
     * @param type $key
     * @return boolean
     */
    public static function remove($key) {
        if (array_key_exists($key, $_SESSION)) {
            unset($_SESSION[$key]);
        }
        return true;
    }

}
