<?php

session_start();
error_reporting(0);
require_once '../framework/function.php';
date_default_timezone_set('Asia/Shanghai');
header("Content-type: text/html; charset=utf-8");
spl_autoload_register(function($classname) {
    $filename = dirname(dirname(__FILE__)) . '/' . str_replace("\\", "/", $classname) . '.php';
    if (file_exists($filename)) {
        require_once $filename;
    }
});
$request = new \framework\Request();
if (!$request->isPost()) {
    return output(statusFailure('请求错误'));
}
$config = require '../config.php';
$connect = mysqli_connect($config['db']['host'] , $config['db']['user'], $config['db']['password'], $config['db']['database'], $config['db']['port']);
if (!$connect) {
    return output(statusFailure('数据库连接失败，请检查'));
}
if (!mysqli_select_db($connect, $config['db']['database'])) {
    return output(statusFailure('数据库不可用，请检查'));
}
mysqli_query($connect, 'SET NAMES utf8');
if ($request->post('type', '') == 'setup2') {
    $setupConf = explode(';', file_get_contents('./data/setup1.sql'));
    if (count($setupConf)) {
        mysqlQuery($connect, $setupConf);
    }
    $setupConf = explode(';', file_get_contents('./data/setup2.sql'));
    if (count($setupConf)) {
        mysqlQuery($connect, $setupConf);
    }
    unset($setupConf);
    mysqli_close($connect);
    return output(statusSuccess());
}
if ($request->post('type', '') == 'setup3') {
    if (!$request->post('passwd1', '')) {
        return output(statusFailure('请输入管理密码'));
    }
    if (!$request->post('passwd2', '')) {
        return output(statusFailure('请再次输入管理密码'));
    }
    if ($request->post('passwd1', '') != $request->post('passwd2', '')) {
        return output(statusFailure('两次输入管理密码不一致，请检查'));
    }
    $_SESSION['passwd'] = $request->post('passwd1', '');
    $passwd = md5(trim($request->post('passwd1', '')));
    $createTime = time();
    $token = md5(substr($passwd, 0, 16));
    mysqli_query($connect, "delete from shangfan_system_admin_user where user='admin';");
    mysqli_query($connect, "insert shangfan_system_admin_user value(NULL,'admin','管理员','{$passwd}',{$createTime},0,1,'{$token}');");
    mysqli_close($connect);
    return output(statusSuccess());
}

function output($status) {
    return \framework\View::output(\framework\Response::json($status));
}

function mysqlQuery(&$connect, &$setupConf) {
    foreach ($setupConf as $val) {
        mysqli_query($connect, $val);
    }
}
