<?php

namespace shangfan\controller\base\h5\mall;

use framework\Request;
use shangfan\model\base\MallCategory;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商城分类
 */
class MallCategoryController {

    /**
     * 分类首页
     * @param Request $request
     * @return string
     */
    public function index(Request $request) {
        $mallCategory = MallCategory::h5Lists(0);
        $assign = compact('mallCategory');
        setTitle('分类首页');
        return view('base.h5.mall.mallCategory.index', $assign);
    }

    /**
     * 商品分类
     * @param Request $request
     * @return string
     */
    public function category(Request $request, $mallCategoryId) {
        $mallCategoryId = intval($mallCategoryId);
        $mallCategory = MallCategory::h5Lists($mallCategoryId);
        $assign = compact('mallCategory');
        setTitle('商品分类');
        return view('base.h5.mall.mallCategory.category', $assign);
    }

    /**
     * ajax商品子类
     * @param Request $request
     * @return string
     */
    public function ajaxCategoryLevel2(Request $request, $mallCategoryId) {
        $mallCategoryId = intval($mallCategoryId);
        $h5CategoryLeve2Lists = MallCategory::h5CategoryLeve2Lists($mallCategoryId);
        $assign = compact('h5CategoryLeve2Lists');
        return view('base.h5.mall.mallCategory.ajaxCategoryLevel2', $assign);
    }

    /**
     * ajax商品子类
     * @param Request $request
     * @return string
     */
    public function ajaxCategoryLevel3(Request $request, $mallCategoryId) {
        $mallCategoryId = intval($mallCategoryId);
        $h5CategoryLeve3Lists = MallCategory::h5CategoryLeve3Lists($mallCategoryId);
        $assign = compact('h5CategoryLeve3Lists');
        return view('base.h5.mall.mallCategory.ajaxCategoryLevel3', $assign);
    }

    /**
     * 商品列表
     * @param Request $request
     * @return string
     */
    public function lists(Request $request) {
        setTitle('商品列表');
        return view('base.h5.mall.mallCategory.lists');
    }

}
