<?php

namespace shangfan\controller\base\h5\mall;

use framework\Request;
use framework\Response;
use framework\Exception;
use framework\Auth;
use framework\pay\wechat\WxPay;
use shangfan\model\base\Order;
use shangfan\model\base\MemberAddress;
use shangfan\model\base\OrderMark;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 订单
 */
class OrderController {

    /**
     * 创建订单
     * @param Request $request
     * @return string
     */
    public function add(Request $request) {
        return Response::json(Order::add($request, Auth::memberH5()));
    }

    /**
     * detail
     * @param Request $request
     * @param type $orderNumberStr
     * @return type
     * @throws Exception
     */
    public static function detail(Request $request, $orderNumberStr) {
        $member = Auth::memberH5();
        if (!$member) {
            return $request->redirect('/h5/member/login/index');
        }
        if (!$orderNumberStr) {
            throw new Exception('缺少订单号');
        }
        if (!MemberAddress::hasAddress($member->id)) {
            return $request->redirect('/h5/member/address/order/add/' . $orderNumberStr);
        }
        $orderNumberArr = explode(',', $orderNumberStr);
        if (!is_array($orderNumberArr) || !count($orderNumberArr)) {
            throw new Exception('缺少订单号');
        }
        $orderArr = Order::listsOrderDetail($orderNumberArr);
        if (!count($orderArr)) {
            throw new Exception('未找到订单');
        }
        $currentOrder = current($orderArr);
        $orderMemberAddress = Order::orderMemberAddress($orderNumberArr);
        $orderTotalAmount = Order::orderTotalAmount($orderNumberArr);
        $listsMemberAddress = MemberAddress::listsMemberAddress($member->id);
        $assign = compact('orderNumberStr', 'orderArr', 'currentOrder', 'orderMemberAddress', 'orderTotalAmount', 'listsMemberAddress');
        setTitle('订单详情');
        return view('base.h5.mall.order.detail', $assign);
    }

    /**
     * 创建订单
     * @param Request $request
     * @return string
     */
    public function updateMark(Request $request) {
        return Response::json(OrderMark::updateMark($request, Auth::memberH5()));
    }

    /**
     * orderPayBalance
     * @param Request $request
     * @return type
     */
    public function orderPayBalance(Request $request) {
        return Response::json(Order::orderPayBalance($request, Auth::memberH5()));
    }

    /**
     * 检查地址
     * @param Request $request
     * @param type $orderNumberStr
     * @return type
     */
    public function checkAddress(Request $request, $orderNumberStr) {
        $successs = Order::orderCheckAddress($orderNumberStr);
        if ($successs) {
            return Response::json(statusSuccess());
        }
        return Response::json(statusFailure('请完善订单收货地址'));
    }

}
