<?php

namespace shangfan\controller\base\h5\member;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\SystemCity;
use shangfan\model\base\MemberAddress;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 地址管理
 */
class MemberAddressController {

    /**
     * 新增地址
     * @param Request $request
     * @return type
     */
    public function add(Request $request) {
        if ($request->isPost()) {
            return Response::json(MemberAddress::add($request, Auth::memberH5()));
        }
        $listsProvince = SystemCity::listsProvince();
        $assign = compact('listsProvince');
        return view('base.h5.member.address.add', $assign);
    }

    /**
     * 地址列表
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        if ($request->isPost()) {
            return Response::json(MemberAddress::add($request, Auth::memberH5()));
        }
        $member = Auth::memberH5();
        $listsMemberAddress = MemberAddress::listsMemberAddress($member->id);
        $assign = compact('listsMemberAddress', 'orderNumberStr');
        return view('base.h5.member.address.lists', $assign);
    }

    /**
     * 删除地址
     * @param Request $request
     * @return type
     */
    public function del(Request $request, $addressId) {
        return Response::json(MemberAddress::del(Auth::memberH5(), $addressId));
    }

    /**
     * 订单新增地址
     * @param Request $request
     * @return type
     */
    public function orderAdd(Request $request, $orderNumberStr) {
        if ($request->isPost()) {
            return Response::json(MemberAddress::orderAdd($request, Auth::memberH5(), $orderNumberStr));
        }
        $listsProvince = SystemCity::listsProvince();
        $assign = compact('listsProvince', 'orderNumberStr');
        return view('base.h5.member.address.orderAdd', $assign);
    }

    /**
     * 订单地址列表
     * @param Request $request
     * @return type
     */
    public function orderLists(Request $request, $orderNumberStr) {
        if ($request->isPost()) {
            return Response::json(MemberAddress::add($request, Auth::memberH5()));
        }
        $member = Auth::memberH5();
        $listsMemberAddress = MemberAddress::listsMemberAddress($member->id);
        $assign = compact('listsMemberAddress', 'orderNumberStr');
        return view('base.h5.member.address.orderLists', $assign);
    }

    /**
     * orderUse
     * @param Request $request
     * @return type
     */
    public function orderUse(Request $request) {
        $orderNumberStr = $request->post('orderNumberStr', '');
        $addressId = intval($request->post('addressId', 0));
        return Response::json(MemberAddress::orderUse(Auth::memberH5(), $orderNumberStr, $addressId));
    }

    /**
     * city
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public function city(Request $request, $pid) {
        return Response::json(SystemCity::ajaxCity($pid));
    }

    /**
     * county
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public function county(Request $request, $pid) {
        return Response::json(SystemCity::ajaxCity($pid));
    }

}
