<?php

namespace shangfan\controller\base\h5\member;

use framework\Request;
use framework\Response;
use framework\Exception;
use framework\Auth;
use shangfan\model\base\Order;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 订单
 */
class OrderController {

    /**
     * lists
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        $member = Auth::memberH5();
        if (!$member) {
            return $request->redirect('/member/login/index');
        }
        $listsMemberOrder = Order::h5ListsMemberOrder($request, $member->id);
        $type = $request->get('type', 'all');
        $assign = compact('listsMemberOrder', 'type');
        setTitle('订单详情');
        return view('base.h5.member.order.lists', $assign);
    }
    
    /**
     * delivery
     * @param Request $request
     * @param type $orderNumber
     * @return type
     */
    public function delivery(Request $request, $orderNumber){
        return Response::json(Order::delivery($request, $orderNumber, Auth::memberH5()));
    }

}
