<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\SystemAdminUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商城管理
 */
class MainController {

    /**
     * 商城管理首页
     * @param Request $request
     * @return type
     */
    public function index(Request $request) {
        $h5DomainBase64 = base64_encode('http://'.rootDomain().'/h5/mall/index');
        $assign = compact('h5DomainBase64');
        setTitle('商城管理首页');
        return view('base.web.admin.main.index', $assign);
    }

    /**
     * passwd
     * @param Request $request
     * @return type
     */
    public function passwd(Request $request) {
        if ($request->isPost()) {
            return Response::json(SystemAdminUser::password($request, Auth::admin()));
        }
        setTitle('修改密码');
        return view('base.web.admin.main.passwd');
    }

    /**
     * 二维码
     * @param Request $request
     * @return type
     * @throws Exception
     */
    public function qrcode(Request $request, $string) {
        $string = base64_decode($string);
        return qrcodeCreate($string);
    }

}
