<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use shangfan\model\base\ShopCategory;
use shangfan\model\base\MallCategory;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商城分类管理
 */
class MallCategoryController {

    /**
     * 添加商城大类
     * @param Request $request
     * @return type
     */
    public function addLevel1(Request $request) {
        if ($request->isPost()) {
            return Response::json(MallCategory::addlevel1($request));
        }
        setTitle('添加商城大类');
        return view('base.web.admin.mallCategory.addLevel1');
    }

    /**
     * 添加商城二类
     * @param Request $request
     * @return type
     */
    public function addLevel2(Request $request) {
        if ($request->isPost()) {
            return Response::json(MallCategory::addlevel2($request));
        }
        setTitle('添加商城二类');
        return view('base.web.admin.mallCategory.addLevel2');
    }

    /**
     * 添加商城小类
     * @param Request $request
     * @return type
     */
    public function addLevel3(Request $request) {
        if ($request->isPost()) {
            return Response::json(MallCategory::addlevel3($request));
        }
        setTitle('添加商城小类');
        return view('base.web.admin.mallCategory.addLevel3');
    }

    /**
     * 分类列表
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        $results = MallCategory::listsLevel($request);
        $assign = compact('results');
        setTitle('商城分类列表');
        return view('base.web.admin.mallCategory.lists', $assign);
    }

    /**
     * 修改小类
     * @param Request $request
     * @param type $id
     * @return type
     */
    public function edit(Request $request, $id) {
        if ($request->isPost()) {
            $success = MallCategory::edit($request, $id);
            return Response::json($success);
        }
        $mallCategory = MallCategory::detail($id);
        if (!$mallCategory) {
            throw new Exception("未找到该分类数据");
        }
        if ($mallCategory->level == 1) {
            $assign = compact('mallCategory');
            setTitle('修改大类');
            return view('base.web.admin.mallCategory.editLevel1', $assign);
        }
        if ($mallCategory->level == 2) {
            $assign = compact('mallCategory');
            setTitle('修改二类');
            return view('base.web.admin.mallCategory.editLevel2', $assign);
        }
        if ($mallCategory->level == 3) {
            $mallCategorySid = MallCategory::detail($mallCategory->pid);
            $assign = compact('mallCategory', 'mallCategorySid');
            setTitle('修改小类');
            return view('base.web.admin.mallCategory.editLevel3', $assign);
        }
    }

    /**
     * 删除分类
     * @param Request $request
     * @param type $id
     * @return type
     * @throws Exception
     */
    public function del(Request $request, $id) {
        return Response::json(MallCategory::del($id));
    }

    /**
     * h5分类列表
     * @param Request $request
     * @return type
     */
    public function h5Lists(Request $request) {
        $results = MallCategory::listsLevel($request);
        $assign = compact('results');
        setTitle('商城分类列表');
        return view('base.web.admin.mallCategory.h5Lists', $assign);
    }

    /**
     * h5修改小类
     * @param Request $request
     * @param type $id
     * @return type
     */
    public function h5Edit(Request $request, $id) {
        if ($request->isPost()) {
            $success = MallCategory::h5Edit($request, $id);
            return Response::json($success);
        }
        $mallCategory = MallCategory::detail($id);
        if (!$mallCategory) {
            throw new Exception("未找到该分类数据");
        }
        $assign = compact('mallCategory');
        setTitle('修改商城分类');
        return view('base.web.admin.mallCategory.h5Edit', $assign);
    }

    /**
     * h5显示分类
     * @param Request $request
     * @param type $id
     * @return type
     * @throws Exception
     */
    public function h5Show(Request $request, $id) {
        return Response::json(MallCategory::h5Show($id));
    }

    /**
     * h5隐藏分类
     * @param Request $request
     * @param type $id
     * @return type
     */
    public function h5Hide(Request $request, $id) {
        return Response::json(MallCategory::h5Hide($id));
    }

    /**
     * ajax商城pid大类
     * @param Request $request
     * @return type
     */
    public function ajaxLevel1(Request $request) {
        return Response::json(MallCategory::ajaxLevel($request, 0));
    }

    /**
     * ajax商城sid小类
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public function ajaxLevel2(Request $request, $pid) {
        return Response::json(MallCategory::ajaxLevel($request, $pid));
    }

    /**
     * ajax商城小类
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public function ajaxLevel3(Request $request, $pid) {
        return $this->ajaxLevel2($request, $pid);
    }

}
