<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use framework\Auth;
use framework\Exception;
use shangfan\model\base\Order;
use shangfan\model\base\OrderGoods;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 订单
 */
class OrderController {

    /**
     * 商品管理
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        if ($request->isPost()) {
            return Response::json(ShopGoods::addBase($request, Auth::merchant()));
        }
        $results = Order::listsAdmin($request);
        $assign = compact('results');
        setTitle('订单列表');
        return view('base.web.admin.order.lists', $assign);
    }

    /**
     * 订单详情
     * @param Request $request
     * @return type
     */
    public function goodsDetail(Request $request, $orderNumber) {
        $order = Order::detail($orderNumber);
        if (!$order) {
            throw new Exception('未找到订单');
        }
        $listsOrderGoods = OrderGoods::listsOrderGoods($orderNumber);
        $assign = compact('order', 'listsOrderGoods');
        setTitle('订单详情');
        return view('base.web.admin.order.goodsDetail', $assign);
    }

}
