<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use shangfan\model\base\SystemFocus;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 焦点图管理
 */
class SystemFocusController {

    /**
     * PC焦点图列表
     * @param Request $request
     * @return type
     */
    public function pcLists(Request $request) {
        $pcLists = SystemFocus::pcLists($request);
        $assign = compact('pcLists');
        setTitle('PC焦点图列表');
        return view('base.web.admin.systemFocus.pcLists', $assign);
    }

    /**
     * pcAddStep1
     * @param Request $request
     * @return type
     */
    public function pcAddStep1(Request $request) {
        if ($request->isPost()) {
            return Response::json(SystemFocus::pcAddStep1($request));
        }
        $pcLists = SystemFocus::pcLists($request);
        $assign = compact('pcLists');
        setTitle('添加焦点图');
        return view('base.web.admin.systemFocus.pcAddStep1', $assign);
    }

    /**
     * 修改焦点图
     * @param Request $request
     * @return type
     */
    public function pcEditStep1(Request $request, $focusId) {
        if ($request->isPost()) {
            return Response::json(SystemFocus::pcEditStep1($request, $focusId));
        }
        $systemFocus = SystemFocus::detail($focusId);
        $assign = compact('systemFocus');
        setTitle('修改焦点图');
        return view('base.web.admin.systemFocus.pcEditStep1', $assign);
    }

    /**
     * 添加焦点图
     * @param Request $request
     * @return type
     */
    public function pcAddStep2(Request $request, $focusId) {
        $systemFocus = SystemFocus::detail($focusId);
        $assign = compact('systemFocus');
        setTitle('添加焦点图');
        return view('base.web.admin.systemFocus.pcAddStep2', $assign);
    }

    /**
     * 上架焦点图
     * @param Request $request
     * @param type $focusId
     * @return type
     */
    public function pcOnline(Request $request, $focusId) {
        return Response::json(SystemFocus::pcOnline($focusId));
    }

    /**
     * 下架焦点图
     * @param Request $request
     * @param type $focusId
     * @return type
     */
    public function pcOffline(Request $request, $focusId) {
        return Response::json(SystemFocus::pcOffline($focusId));
    }

    /**
     * 删除焦点图
     * @param Request $request
     * @param type $focusId
     * @return type
     */
    public function pcDel(Request $request, $focusId) {
        return Response::json(SystemFocus::pcDel($focusId));
    }

    /**
     * H5焦点图列表
     * @param Request $request
     * @return type
     */
    public function h5Lists(Request $request) {
        $h5Lists = SystemFocus::h5Lists($request);
        $assign = compact('h5Lists');
        setTitle('H5手机焦点图列表');
        return view('base.web.admin.systemFocus.h5Lists', $assign);
    }

    /**
     * h5添加焦点图
     * @param Request $request
     * @return type
     */
    public function h5AddStep1(Request $request) {
        if ($request->isPost()) {
            return Response::json(SystemFocus::h5AddStep1($request));
        }
        setTitle('添加焦点图');
        return view('base.web.admin.systemFocus.h5AddStep1');
    }

    /**
     * h5修改焦点图
     * @param Request $request
     * @return type
     */
    public function h5EditStep1(Request $request, $focusId) {
        if ($request->isPost()) {
            return Response::json(SystemFocus::h5EditStep1($request, $focusId));
        }
        $systemFocus = SystemFocus::detail($focusId);
        $assign = compact('systemFocus');
        setTitle('修改焦点图');
        return view('base.web.admin.systemFocus.h5EditStep1', $assign);
    }

    /**
     * h5添加焦点图
     * @param Request $request
     * @return type
     */
    public function h5AddStep2(Request $request, $focusId) {
        $systemFocus = SystemFocus::detail($focusId);
        $assign = compact('systemFocus');
        setTitle('添加焦点图');
        return view('base.web.admin.systemFocus.h5AddStep2', $assign);
    }

    /**
     * h5上架焦点图
     * @param Request $request
     * @param type $focusId
     * @return type
     */
    public function h5Online(Request $request, $focusId) {
        return Response::json(SystemFocus::h5Online($focusId));
    }

    /**
     * h5下架焦点图
     * @param Request $request
     * @param type $focusId
     * @return type
     */
    public function h5Offline(Request $request, $focusId) {
        return Response::json(SystemFocus::h5Offline($focusId));
    }

    /**
     * h5删除焦点图
     * @param Request $request
     * @param type $focusId
     * @return type
     */
    public function h5Del(Request $request, $focusId) {
        return Response::json(SystemFocus::h5Del($focusId));
    }

}
