<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use shangfan\model\base\SystemNavigation;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 导航管理
 */
class SystemNavigationController {

    /**
     * 添加导航
     * @param Request $request
     * @return type
     */
    public function add(Request $request) {
        if ($request->isPost()) {
            return Response::json(SystemNavigation::add($request));
        }
        return view('base.web.admin.systemNavigation.add');
    }

    /**
     * 网站设置
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        $systemNavigation = SystemNavigation::lists();
        $assign = compact('systemNavigation');
        setTitle('导航列表');
        return view('base.web.admin.systemNavigation.lists', $assign);
    }

    /**
     * 修改导航
     * @param Request $request
     * @return type
     */
    public function edit(Request $request, $navigationId) {
        if ($request->isPost()) {
            return Response::json(SystemNavigation::edit($request, $navigationId));
        }
        $systemNavigation = SystemNavigation::detail($navigationId);
        $assign = compact('systemNavigation');
        setTitle('导航列表');
        return view('base.web.admin.systemNavigation.edit', $assign);
    }

    /**
     * hide
     * @param Request $request
     * @param type $navigationId
     * @return type
     */
    public function hide(Request $request, $navigationId) {
        return Response::json(SystemNavigation::hide($request, $navigationId));
    }

    /**
     * show
     * @param Request $request
     * @param type $navigationId
     * @return type
     */
    public function show(Request $request, $navigationId) {
        return Response::json(SystemNavigation::show($request, $navigationId));
    }

    /**
     * del
     * @param Request $request
     * @param type $navigationId
     * @return type
     */
    public function del(Request $request, $navigationId) {
        return Response::json(SystemNavigation::del($request, $navigationId));
    }

}
