<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use framework\file\Upload;
use framework\Auth;
use shangfan\model\base\SystemFocus;
use shangfan\model\base\MallCategory;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 文件上传
 */
class UploadController {

    /**
     * upload
     * @param Request $request
     * @param type $type 
     * @return type
     */
    public function upload(Request $request, $type) {
        if (!$request->isFile()) {
            return Response::json(statusFailure('请选择文件'));
        }
        if ($type == 'focuspc') {
            return $this->uploadFocuspc($request, $type);
        }
        if ($type == 'focush5') {
            return $this->uploadFocush5($request, $type);
        }
        if ($type == 'mallcategoryh5') {
            return $this->uploadMallCategoryH5($request, $type);
        }
    }

    /**
     * pc焦点图
     * @param Request $request
     * @param type $type
     * @return type
     */
    private function uploadFocuspc(Request $request, $type) {
        if ($type != 'focuspc') {
            return statusFailure('上传模型错误');
        }
        if (!Auth::hasLogin('admin')) {
            return statusFailure('登录超时，请重新登录');
        }
        $focusId = $request->post('focusId', 0);
        if (!$focusId) {
            return statusFailure('缺少焦点图相关参数，请刷新重试');
        }
        $date = date('Ymd');
        $uploadPicDir = Upload::getUploadPicDir($type, $date);
        if (!Upload::checkExtension()) {
            return Response::json(statusFailure('上传类型错误，请上传图片文件'));
        }
        $uploadFilePath = Upload::getUploadFilePath();
        if (Upload::moveUploadedFile($uploadPicDir, $uploadFilePath)) {
            $httpPath = Upload::getUploadHttpPath($type, $date, $uploadFilePath);
            SystemFocus::updateFocusPic(Auth::admin(), $focusId, $httpPath);
            return Response::json(statusSuccess('上传成功', ['httpPath' => $httpPath]));
        }
        return Response::json(statusFailure('上传失败，请重试'));
    }

    /**
     * h5焦点图
     * @param Request $request
     * @param type $type
     * @return type
     */
    private function uploadFocush5(Request $request, $type) {
        if ($type != 'focush5') {
            return statusFailure('上传模型错误');
        }
        if (!Auth::hasLogin('admin')) {
            return statusFailure('登录超时，请重新登录');
        }
        $focusId = $request->post('focusId', 0);
        if (!$focusId) {
            return statusFailure('缺少焦点图相关参数，请刷新重试');
        }
        $date = date('Ymd');
        $uploadPicDir = Upload::getUploadPicDir($type, $date);
        if (!Upload::checkExtension()) {
            return Response::json(statusFailure('上传类型错误，请上传图片文件'));
        }
        $uploadFilePath = Upload::getUploadFilePath();
        if (Upload::moveUploadedFile($uploadPicDir, $uploadFilePath)) {
            $httpPath = Upload::getUploadHttpPath($type, $date, $uploadFilePath);
            SystemFocus::updateFocusPic(Auth::admin(), $focusId, $httpPath);
            return Response::json(statusSuccess('上传成功', ['httpPath' => $httpPath]));
        }
        return Response::json(statusFailure('上传失败，请重试'));
    }

    /**
     * h5商城分类
     * @param Request $request
     * @param type $type
     * @return type
     */
    private function uploadMallCategoryH5(Request $request, $type) {
        if ($type != 'mallcategoryh5') {
            return statusFailure('上传模型错误');
        }
        if (!Auth::hasLogin('admin')) {
            return statusFailure('登录超时，请重新登录');
        }
        $mallCategoryId = $request->post('mallCategoryId', 0);
        if (!$mallCategoryId) {
            return statusFailure('缺少焦点图相关参数，请刷新重试');
        }
        $date = date('Ymd');
        $uploadPicDir = Upload::getUploadPicDir($type, $date);
        if (!Upload::checkExtension()) {
            return Response::json(statusFailure('上传类型错误，请上传图片文件'));
        }
        $uploadFilePath = Upload::getUploadFilePath();
        if (Upload::moveUploadedFile($uploadPicDir, $uploadFilePath)) {
            $httpPath = Upload::getUploadHttpPath($type, $date, $uploadFilePath);
            MallCategory::updateH5Pic(Auth::admin(), $mallCategoryId, $httpPath);
            return Response::json(statusSuccess('上传成功', ['httpPath' => $httpPath]));
        }
        return Response::json(statusFailure('上传失败，请重试'));
    }

}
