<?php

namespace shangfan\controller\base\web\member;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\SystemCity;
use shangfan\model\base\MemberAddress;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 地址管理
 */
class MemberAddressController {

    /**
     * 新增地址
     * @param Request $request
     * @return type
     */
    public function add(Request $request) {
        if ($request->isPost()) {
            return Response::json(MemberAddress::add($request, Auth::member()));
        }
        $listsProvince = SystemCity::listsProvince();
        $assign = compact('listsProvince');
        return view('base.web.member.address.add', $assign);
    }

    /**
     * city
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public function city(Request $request, $pid) {
        return Response::json(SystemCity::ajaxCity($pid));
    }

    /**
     * county
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public function county(Request $request, $pid) {
        return Response::json(SystemCity::ajaxCity($pid));
    }

}
