<?php

namespace shangfan\controller\base\web\member;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\MemberFocusShop;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 店铺关注
 */
class MemberFocusShopController {

    /**
     * 店铺关注
     * @param Request $request
     * @return type
     */
    public function ajaxAdd(Request $request) {
        return Response::json(MemberFocusShop::add($request, Auth::member()));
    }
    
    /**
     * lists
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        $results = MemberFocusShop::lists($request, Auth::member());
        $assign = compact('results');
        setTitle('我关注的店铺');
        return view('base.web.member.focusShop.lists', $assign);
    }

    /**
     * 删除商品关注
     * @param Request $request
     * @return type
     */
    public function del(Request $request, $memberFocusShopId) {
        return Response::json(MemberFocusShop::del(Auth::member(), $memberFocusShopId));
    }

}
