<?php

namespace shangfan\controller\base\web\merchant;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\develop\ShopUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商家登录
 */
class LoginController {

    /**
     * 商家登录
     * @param Request $request
     * @return type
     */
    public function index(Request $request) {
        setTitle('商家登录');
        return view('base.web.merchant.login.index');
    }

    /**
     * 登录提交
     * @param Request $request
     * @return type
     */
    public function login(Request $request) {
        return Response::json(ShopUser::login($request));
    }

    /**
     * 退出登录
     * @param Request $request
     * @return type
     */
    public function loginout(Request $request) {
        Auth::remove('merchant');
        return $request->redirect('/merchant/login/index');
    }

}
