<?php

namespace shangfan\controller\base\web\shop;

use framework\Request;
use shangfan\model\base\ShopInfo;
use shangfan\model\base\ShopUser;
use shangfan\model\base\ShopGoods;
use shangfan\model\base\ShopCategory;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 店铺首页
 */
class ShopHomeController {

    /**
     * 店铺首页
     * @param Request $request
     * @return type
     */
    public function home(Request $request, $md5) {
        $shopInfo = ShopInfo::detailMd5($md5);
        if (!$shopInfo) {
            return $request->redirect('/');
        }
        $shopUser = ShopUser::detail($shopInfo->shop_user_id);
        if($shopUser->is_online != 1){
            return $request->redirect('/shop/error/'.$shopInfo->md5);
        }
        $results = ShopGoods::listsShopHomeIndex($request);
        $assign = compact('request','shopInfo', 'results');
        setTitle($shopInfo->name);
        return view('base.web.shop.shopHome.home', $assign);
    }

    /**
     * 在售商品
     * @param Request $request
     * @return type
     */
    public function putaway(Request $request, $md5, $shopCategoryId = 0) {
        $shopCategoryId = intval($shopCategoryId);
        $shopInfo = ShopInfo::detailMd5($md5);
        if (!$shopInfo) {
            return $request->redirect('/');
        }
        $shopUser = ShopUser::detail($shopInfo->shop_user_id);
        if($shopUser->is_online != 1){
            return $request->redirect('/shop/error/'.$shopInfo->md5);
        }
        $shopCategoryLists = ShopCategory::shopLists($request, $shopUser, $shopInfo);
        $shopCategory = null;
        if ($shopCategoryId) {
            $shopCategory = ShopCategory::detail($shopCategoryId);
        }
        $results = ShopGoods::listsShopHomePutaway($request, $shopCategoryId);
        $assign = compact('request','shopInfo', 'shopCategoryLists', 'results');
        setTitle($shopCategory ? $shopCategory->name : '在售商品');
        return view('base.web.shop.shopHome.putaway', $assign);
    }

    /**
     * 排行榜
     * @param Request $request
     * @return type
     */
    public function rank(Request $request, $md5) {
        $shopInfo = ShopInfo::detailMd5($md5);
        if (!$shopInfo) {
            return $request->redirect('/');
        }
        $shopUser = ShopUser::detail($shopInfo->shop_user_id);
        if($shopUser->is_online != 1){
            return $request->redirect('/shop/error/'.$shopInfo->md5);
        }
        $shopCategoryLists = ShopCategory::shopLists($request, $shopUser, $shopInfo);
        $results = ShopInfo::shopRank($shopInfo->shop_user_id);
        $assign = compact('request','shopInfo', 'shopCategoryLists', 'results');
        setTitle('排行榜');
        return view('base.web.shop.shopHome.rank', $assign);
    }

    /**
     * 联系客服
     * @param Request $request
     * @return type
     */
    public function contact(Request $request, $md5) {
        $shopInfo = ShopInfo::detailMd5($md5);
        if (!$shopInfo) {
            return $request->redirect('/');
        }
        $shopUser = ShopUser::detail($shopInfo->shop_user_id);
        if($shopUser->is_online != 1){
            return $request->redirect('/shop/error/'.$shopInfo->md5);
        }
        $shopCategoryLists = ShopCategory::shopLists($request, $shopUser, $shopInfo);
        $assign = compact('request','shopInfo', 'shopCategoryLists', 'results');
        setTitle('联系客服');
        return view('base.web.shop.shopHome.contact', $assign);
    }
    /**
     * 店铺提示
     * @param Request $request
     * @return type
     */
    public function error(Request $request, $md5) {
        $shopInfo = ShopInfo::detailMd5($md5);
        if (!$shopInfo) {
            return $request->redirect('/');
        }
        $shopUser = ShopUser::detail($shopInfo->shop_user_id);
        $isOnline = ShopUser::strIsOnline($shopUser->is_online);
        $assign = compact('shopInfo', 'shopUser', 'isOnline');
        setTitle('店铺提示');
        return view('base.web.shop.shopHome.error', $assign);
    }

}
