<?php

namespace shangfan\controller\base\web\shop;

use framework\Request;
use shangfan\model\base\ShopInfo;
use shangfan\model\base\ShopGoods;


/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商家信息
 */
class ShopInfoController {

    /**
     * goShop
     * @param Request $request
     * @param type $md5
     * @return type
     */
    public static function goShop(Request $request, $md5) {
        $shopGoods = ShopInfo::detailMd5($md5);
        if (!$shopGoods) {
            return $request->redirect('/');
        }
        return $request->redirect(url('/shop/home/' . $md5));
    }

    /**
     * goGoods
     * @param Request $request
     * @param type $md5
     * @return type
     */
    public static function goGoods(Request $request, $md5) {
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            return $request->redirect('/');
        }
        return $request->redirect(url('/shop/goods/' . $md5));
    }

}
