<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\SystemAdminUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * MallCategory
 */
class MallCategory extends BaseModel {

    public $table = 'shangfan_mall_category';
    public $key = 'id';

    /**
     * ajaxLevel
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public static function ajaxLevel(Request $request, $pid = 0) {
        $ajaxLists = MallCategory::ajaxLists($request, $pid);
        if (!count($ajaxLists)) {
            return statusSuccess();
        }
        $data = [];
        foreach ($ajaxLists as $val) {
            $data[] = [
                'id' => $val->id,
                'name' => $val->name,
            ];
        }
        return statusSuccess('', $data);
    }

    /**
     * ajaxLists
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public static function ajaxLists(Request $request, $pid = 0) {
        $results = MallCategory::get("select * from {table} where pid={$pid} and status=1;");
        if (!count($results)) {
            return [];
        }
        return $results;
    }

    /**
     * lists
     * @return type
     */
    public static function lists($pid = 0) {
        $mallCategory = MallCategory::get("select * from {table} where pid={$pid} and status=1 order by sort asc;");
        if (!count($mallCategory)) {
            return [];
        }
        foreach ($mallCategory as &$val) {
            $val->strIsShow = MallCategory::strIsShow($val->h5_is_show);
        }
        return $mallCategory;
    }

    /**
     * h5Lists
     * @param type $pid
     * @return type
     */
    public static function h5Lists($pid = 0) {
        $mallCategory = MallCategory::get("select * from {table} where pid={$pid} and status=1 and h5_is_show=1 order by sort asc;");
        if (!count($mallCategory)) {
            return [];
        }
        foreach ($mallCategory as &$val) {
            $val->strIsShow = MallCategory::strIsShow($val->h5_is_show);
            $val->url = url('/h5/mall/category/category/' . $val->id);
        }
        return $mallCategory;
    }

    /**
     * h5CategoryLeve2Lists
     * @param type $pid
     * @return type
     */
    public static function h5CategoryLeve2Lists($pid) {
        if (!$pid) {
            return [];
        }
        $mallCategory = MallCategory::get("select * from {table} where pid={$pid} and status=1 and h5_is_show=1 order by sort asc;");
        if (!count($mallCategory)) {
            return [];
        }
        foreach ($mallCategory as &$val) {
            $val->listsLevel3 = MallCategory::h5CategoryLeve3Lists($val->id);
            $val->url = url('/h5/shop/goods/lists/' . $val->id);
        }
        return $mallCategory;
    }

    /**
     * h5CategoryLeve3Lists
     * @param type $pid
     * @return type
     */
    public static function h5CategoryLeve3Lists($pid) {
        if (!$pid) {
            return [];
        }
        $mallCategory = MallCategory::get("select * from {table} where pid={$pid} and status=1 and h5_is_show=1 order by sort asc;");
        if (!count($mallCategory)) {
            return [];
        }
        foreach ($mallCategory as &$val) {
            $val->url = url('/h5/shop/goods/lists/' . $val->id);
        }
        return $mallCategory;
    }

    /**
     * listsLevel
     * @return type
     */
    public static function listsLevel() {
        $mallCategory = MallCategory::lists();
        if (!count($mallCategory)) {
            return [];
        }
        foreach ($mallCategory as &$cat) {
            $sidLists = MallCategory::lists($cat->id);
            if (!count($sidLists)) {
                continue;
            }
            foreach ($sidLists as &$val) {
                $val->bidLists = MallCategory::lists($val->id);
            }
            $cat->sidLists = $sidLists;
        }
        return $mallCategory;
    }

    /**
     * confArray
     * @param type $shopUserId
     * @return type
     */
    public static function confArray() {
        $results = ShopCategory::get("select * from {table} where status=1 order by sort asc;");
        if (!count($results)) {
            return [];
        }
        $data = [];
        foreach ($results as $val) {
            $data[$val->id] = $val->title;
        }
        return $data;
    }

    /**
     * addlevel1
     * @param Request $request
     * @param ShopUser $shopUser
     * @return type
     */
    public static function addlevel1(Request $request) {
        if (!$request->post('name', '')) {
            return statusFailure('请输入大类名称');
        }
        $exist = MallCategory::existCategory($request->post('name', ''));
        if ($exist) {
            return statusFailure('您已经添加了该大类，请检查');
        }
        $success = MallCategory::insert([
                    'pid' => 0,
                    'name' => $request->post('name', ''),
                    'sort' => 0,
                    'create_time' => time(),
                    'level' => 1,
                    'status' => 1,
                    'h5_name' => $request->post('h5_name', ''),
                    'h5_sort' => 0,
                    'h5_is_show' => 0,
        ]);
        if (!$success) {
            return statusFailure('添加大类失败，请重试');
        }
        return statusSuccess('添加大类成功');
    }

    /**
     * addlevel2
     * @param Request $request
     * @param ShopUser $shopUser
     * @return type
     */
    public static function addlevel2(Request $request) {
        if (!$request->post('pid', 0)) {
            return statusFailure('请选择大类');
        }
        if (!$request->post('name', '')) {
            return statusFailure('请输入类别名称');
        }
        $pid = intval($request->post('pid', 0));
        $exist = MallCategory::existCategory($request->post('name', ''), $pid);
        if ($exist) {
            return statusFailure('您在该大类下已经添加了该小类，请检查');
        }
        $success = MallCategory::insert([
                    'pid' => $pid,
                    'name' => $request->post('name', ''),
                    'sort' => 0,
                    'create_time' => time(),
                    'status' => 1,
                    'level' => 2,
                    'h5_name' => $request->post('h5_name', ''),
                    'h5_sort' => 0,
                    'h5_is_show' => 0,
        ]);
        if (!$success) {
            return statusFailure('添加类别失败，请重试或联系客服');
        }
        return statusSuccess('添加类别成功');
    }

    /**
     * addlevel3
     * @param Request $request
     * @param ShopUser $shopUser
     * @return type
     */
    public static function addlevel3(Request $request) {
        if (!$request->post('pid', 0)) {
            return statusFailure('请选择大类');
        }
        if (!$request->post('name', '')) {
            return statusFailure('请输入类别名称');
        }
        $pid = intval($request->post('pid', 0));
        $exist = MallCategory::existCategory($request->post('name', ''), $pid);
        if ($exist) {
            return statusFailure('您在该大类下已经添加了该小类，请检查');
        }
        $success = MallCategory::insert([
                    'pid' => $pid,
                    'name' => $request->post('name', ''),
                    'sort' => 0,
                    'create_time' => time(),
                    'status' => 1,
                    'level' => 3,
                    'h5_name' => $request->post('h5_name', ''),
                    'h5_sort' => 0,
                    'h5_is_show' => 0,
        ]);
        if (!$success) {
            return statusFailure('添加类别失败，请重试或联系客服');
        }
        return statusSuccess('添加类别成功');
    }

    /**
     * listSecond
     * @param Request $request
     * @param ShopUser $shopUser
     * @param type $pid
     * @return type
     */
    public static function listSecond(Request $request, ShopUser $shopUser, $pid = 0) {
        return ShopCategory::get("select * from {table} where shop_user_id={$shopUser->id} and pid={$pid} and status=1 order by sort asc;");
    }

    /**
     * countCategory
     * @param type $pid
     * @return type
     */
    public static function countCategory($pid = 0) {
        return ShopCategory::count("select count(id) as count from {table} where pid={$pid} and status=1;");
    }

    /**
     * edit
     * @param Request $reuqest
     * @param ShopUser $shopUser
     * @param type $id
     * @return type
     */
    public static function edit(Request $reuqest, $id) {
        $mallCategory = MallCategory::detail($id);
        if (!$mallCategory) {
            return statusFailure('未找到数据，请检查');
        }
        if ($mallCategory->level == 1) {
            if (!$reuqest->post('name', '')) {
                return statusFailure('请输入大类名称');
            }
            $mallCategory->name = $reuqest->post('name', '');
            if (!$mallCategory->save()) {
                return statusFailure('修改失败，请重试');
            }
            return statusSuccess('修改成功');
        }
        if (!$reuqest->post('pid', 0)) {
            return statusFailure('请选择大类');
        }
        if (!$reuqest->post('name', '')) {
            return statusFailure('请输入分类名称');
        }
        $mallCategory->pid = intval($reuqest->post('pid', 0));
        $mallCategory->name = $reuqest->post('name', '');
        if (!$mallCategory->save()) {
            return statusFailure('修改失败，请重试或联系客服');
        }
        return statusSuccess('修改成功');
    }

    /**
     * del
     * @param type $id
     * @return type
     */
    public static function del($id) {
        $mallCategory = MallCategory::detail($id);
        if (!$mallCategory) {
            return statusFailure('未找到分类数据，请检查或联系客服');
        }
        if ($mallCategory->level == 1) {
            if (ShopGoods::countPidGoodsNumber($mallCategory->id) > 0) {
                return statusFailure('分类下还有商品，请先清空商品再删除');
            }
        }
        if ($mallCategory->level == 2) {
            if (ShopGoods::countSidGoodsNumber($mallCategory->id) > 0) {
                return statusFailure('分类下还有商品，请先清空商品再删除');
            }
        }
        if ($mallCategory->level == 3) {
            if (ShopGoods::countIdGoodsNumber($mallCategory->id) > 0) {
                return statusFailure('分类下还有商品，请先清空商品再删除');
            }
        }
        $mallCategory->status = 0;
        if (!$mallCategory->save()) {
            return statusFailure('删除失败，请重试或联系客服');
        }
        return statusSuccess('删除成功');
    }

    /**
     * pidConf
     * @param type $id
     * @return type
     */
    public static function pidConf($id) {
        $mallCategory = MallCategory::detail($id);
        if (!$mallCategory) {
            return [];
        }
        if ($mallCategory->level == 1) {
            return [$mallCategory->id];
        }
        if ($mallCategory->level == 2) {
            return [$mallCategory->id, $mallCategory->pid];
        }
        if ($mallCategory->level == 3) {
            $mallCategorySid = MallCategory::del($mallCategory->pid);
            if (!$mallCategorySid) {
                return [$mallCategory->id, $mallCategory->pid];
            }
            return [$mallCategorySid->pid, $mallCategorySid->id, $mallCategory->id];
        }
        return [];
    }

    /**
     * existCategory
     * @param type $name
     * @param type $pid
     * @return type
     */
    public static function existCategory($name, $pid = 0) {
        if ($pid > 0) {
            $count = MallCategory::count("select count(id) as count from {table} where pid={$pid} and name='{$name}' and status=1;");
            return $count ? true : false;
        }
        $count = MallCategory::count("select count(id) as count from {table} where name='{$name}' and status=1;");
        return $count ? true : false;
    }

    /**
     * updateH5Pic
     * @param SystemAdminUser $systemAdminUser
     * @param type $mallCategoryId
     * @param type $picSrc
     * @return boolean
     */
    public static function updateH5Pic(SystemAdminUser $systemAdminUser, $mallCategoryId, $picSrc) {
        if (!$systemAdminUser || !$mallCategoryId || !$picSrc) {
            return false;
        }
        $mallCategory = MallCategory::detail($mallCategoryId);
        if (!$mallCategory) {
            return false;
        }
        $unlinkPicSrc = rootPath() . '/public' . $mallCategory->h5_pic;
        if (file_exists($unlinkPicSrc)) {
            @unlink($unlinkPicSrc);
        }
        $mallCategory->fill([
            'h5_pic' => $picSrc,
            'h5_admin_user_id' => $systemAdminUser->id,
        ]);
        return $mallCategory->save();
    }

    /**
     * h5Show
     * @param type $id
     * @return type
     */
    public static function h5Show($id) {
        $mallCategory = MallCategory::detail($id);
        if (!$mallCategory) {
            return statusFailure('未找到分类数据，请检查或联系客服');
        }
        if ($mallCategory->h5_is_show == 1) {
            return statusSuccess('操作成功');
        }
        $mallCategory->h5_is_show = 1;
        if (!$mallCategory->save()) {
            return statusFailure('操作失败，请重试或联系客服');
        }
        return statusSuccess('操作成功');
    }

    /**
     * h5Hide
     * @param type $id
     * @return type
     */
    public static function h5Hide($id) {
        $mallCategory = MallCategory::detail($id);
        if (!$mallCategory) {
            return statusFailure('未找到分类数据，请检查或联系客服');
        }
        if ($mallCategory->h5_is_show == 0) {
            return statusSuccess('操作成功');
        }
        $mallCategory->h5_is_show = 0;
        if (!$mallCategory->save()) {
            return statusFailure('操作失败，请重试或联系客服');
        }
        return statusSuccess('操作成功');
    }

    /**
     * h5Edit
     * @param Request $reuqest
     * @param ShopUser $shopUser
     * @param type $id
     * @return type
     */
    public static function h5Edit(Request $reuqest, $id) {
        $mallCategory = MallCategory::detail($id);
        if (!$mallCategory) {
            return statusFailure('未找到数据，请检查');
        }
        if (!$reuqest->post('h5_name', '')) {
            return statusFailure('请输入大类名称');
        }
        $mallCategory->h5_name = $reuqest->post('h5_name', '');
        $mallCategory->h5_sort = intval($reuqest->post('h5_sort', 0));
        if (!$mallCategory->save()) {
            return statusFailure('修改失败，请重试');
        }
        return statusSuccess('修改成功');
    }

    /**
     * strIsShow
     * @param type $isShow
     * @return string
     */
    public static function strIsShow($isShow) {
        if ($isShow == 1) {
            return '显示';
        }
        if ($isShow == 0) {
            return '隐藏';
        }
        return '-';
    }

    /**
     * strName
     * @param type $mallCategoryId
     * @return string
     */
    public static function strName($mallCategoryId) {
        $mallCategory = MallCategory::detail($mallCategoryId);
        if (!$mallCategory) {
            return '';
        }
        return $mallCategory->name;
    }

    /**
     * detail
     * @param type $mallCategoryId
     * @return type
     */
    public static function detail($mallCategoryId) {
        return MallCategory::first("select * from {table} where id={$mallCategoryId} and status=1;");
    }

    /**
     * level1CategoryId
     * @param type $mallCategoryId
     * @return int
     */
    public static function level1CategoryId($mallCategoryId) {
        $detail = MallCategory::detail($mallCategoryId);
        if (!$detail) {
            return 0;
        }
        if ($detail->pid != 0) {
            return MallCategory::level1CategoryId($detail->pid);
        }
        return $detail->id;
    }

}
