<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\MemberUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * MemberAddress
 */
class MemberAddress extends BaseModel {

    public $table = 'shangfan_member_address';
    public $key = 'id';

    /**
     * add
     * @param Request $request
     * @param MemberUser $memberUser
     * @return type
     */
    public static function add(Request $request, MemberUser $memberUser) {
        if (!$request->post('province_id', 0)) {
            return statusFailure('请选择省');
        }
        if (!$request->post('city_id', 0)) {
            return statusFailure('请选择市');
        }
        if (!$request->post('county_id', 0)) {
            return statusFailure('请选择区县');
        }
        if (!$request->post('address', '')) {
            return statusFailure('请填写详细地址');
        }
        if (!$request->post('name', '')) {
            return statusFailure('请填写收货人姓名');
        }
        if (!$request->post('phone', '')) {
            return statusFailure('请填写收货人电话');
        }
        MemberAddress::update("update {table} set is_default=0 where member_user_id={$memberUser->id};");
        $success = MemberAddress::insert([
                    'member_user_id' => $memberUser->id,
                    'province_id' => $request->post('province_id', 0),
                    'city_id' => $request->post('city_id', 0),
                    'county_id' => $request->post('county_id', 0),
                    'address' => $request->post('address', ''),
                    'name' => $request->post('name', ''),
                    'phone' => $request->post('phone', ''),
                    'is_default' => 1,
                    'create_time' => time(),
                    'status' => 1
        ]);
        if (!$success) {
            return statusFailure('新增地址失败，请重试');
        }
        return statusSuccess('新增地址成功', ['insertId' => $success]);
    }

    /**
     * orderAdd
     * @param Request $request
     * @param MemberUser $memberUser
     * @return type
     */
    public static function orderAdd(Request $request, MemberUser $memberUser, $orderNumberStr) {
        $orderNumberArr = explode(',', $orderNumberStr);
        if (!is_array($orderNumberArr) || !count($orderNumberArr)) {
            throw new Exception('订单参数有误');
        }
        $success = MemberAddress::add($request, $memberUser);
        if (!$success['status']) {
            return statusFailure('新增地址失败，请重试');
        }
        $insertId = $success['data']['insertId'];
        foreach ($orderNumberArr as $val) {
            $order = Order::detail($val);
            if (!$order) {
                continue;
            }
            if ($order->member_user_id != $memberUser->id) {
                return statusFailure('您没有权限');
            }
            $order->member_address_id = $insertId;
            if (!$order->save()) {
                return statusFailure('保存失败，请重试');
            }
        }
        return statusSuccess('新增地址成功');
    }

    /**
     * orderUse
     * @param MemberUser $memberUser
     * @param type $orderNumberStr
     * @param type $addressId
     * @return type
     * @throws Exception
     */
    public static function orderUse(MemberUser $memberUser, $orderNumberStr, $addressId) {
        $orderNumberArr = explode(',', $orderNumberStr);
        if (!is_array($orderNumberArr) || !count($orderNumberArr)) {
            throw new Exception('订单参数有误');
        }
        $memberAddress = MemberAddress::detail($addressId);
        if (!$memberAddress) {
            return statusFailure('未找到收货地址数据');
        }
        foreach ($orderNumberArr as $val) {
            $order = Order::detail($val);
            if (!$order) {
                continue;
            }
            if ($order->member_user_id != $memberUser->id) {
                return statusFailure('您没有权限');
            }
            $order->member_address_id = $addressId;
            if (!$order->save()) {
                return statusFailure('保存失败，请重试');
            }
        }
        return statusSuccess();
    }

    /**
     * hasAddress
     * @param type $memberUserId
     * @return type
     */
    public static function hasAddress($memberUserId) {
        $count = MemberAddress::count("select count(id) as count from {table} where member_user_id={$memberUserId} and status=1;");
        return $count ? true : false;
    }

    /**
     * listsMemberAddress
     * @param type $memberUserId
     * @return type
     */
    public static function listsMemberAddress($memberUserId) {
        $memberAddress = MemberAddress::get("select * from {table} where member_user_id={$memberUserId} and status=1 order by create_time desc,id desc;");
        if (!count($memberAddress)) {
            return [];
        }
        foreach ($memberAddress as &$val) {
            $val->provinceName = SystemCity::strCityName($val->province_id);
            $val->cityName = SystemCity::strCityName($val->city_id);
            $val->countyName = SystemCity::strCityName($val->county_id);
            $val->phone = stringPhoneReplace($val->phone);
        }
        return $memberAddress;
    }

    /**
     * del
     * @param MemberUser $memberUser
     * @param type $addressId
     * @return type
     * @throws Exception
     */
    public static function del(MemberUser $memberUser, $addressId) {
        $memberAddress = MemberAddress::detail($addressId);
        if (!$memberAddress) {
            return statusFailure('未找到地址数据，请重试');
        }
        if ($memberAddress->member_user_id != $memberUser->id) {
            return statusFailure('您没有权限');
        }
        $memberAddress->status = 0;
        if (!$memberAddress->save()) {
            return statusFailure('删除地址失败，请重试');
        }
        return statusSuccess('删除地址成功');
    }

    /**
     * detailDefault
     * @param type $memberUserId
     * @return type
     */
    public static function detailDefault($memberUserId) {
        return MemberAddress::first("select * from {table} where member_user_id={$memberUserId} and is_default=1 and status=1;");
    }

    /**
     * detailLimit
     * @param type $memberUserId
     * @return type
     */
    public static function detailLimit($memberUserId) {
        return MemberAddress::first("select * from {table} where member_user_id={$memberUserId} and status=1 order by create_time desc,id desc;");
    }

    /**
     * detail
     * @param type $id
     * @return type
     */
    public static function detail($id) {
        return MemberAddress::first("select * from {table} where id={$id};");
    }

}
