<?php

namespace shangfan\model\base;

use framework\Request;
use framework\paginate\Paginate;
use shangfan\model\base\ShopGoods;
use shangfan\model\base\MemberUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * MemberFocusGoods
 */
class MemberFocusGoods extends BaseModel {

    public $table = 'shangfan_member_focus_goods';
    public $key = 'id';

    /**
     * add
     * @param Request $request
     * @param MemberUser $memberUser
     * @return type
     */
    public static function add(Request $request, $memberUser) {
        if (!$memberUser) {
            return statusFailure('请先登录');
        }
        $shopUserId = intval($request->post('shopUserId', 0));
        if (!$shopUserId) {
            return statusFailure('缺少商家参数');
        }
        $shopGoodsId = intval($request->post('shopGoodsId', 0));
        if (!$shopGoodsId) {
            return statusFailure('缺少商品参数');
        }
        if (MemberFocusGoods::isFocusGoods($memberUser->id, $shopUserId, $shopGoodsId)) {
            return statusSuccess('你已经关注该商品了');
        }
        $success = MemberFocusGoods::insert([
                    'member_user_id' => $memberUser->id,
                    'shop_user_id' => $shopUserId,
                    'shop_goods_id' => $shopGoodsId,
                    'create_time' => time(),
                    'status' => 1
        ]);
        if (!$success) {
            return statusFailure('关注失败，请重试');
        }
        return statusSuccess('关注成功', ['insertId' => $success]);
    }

    /**
     * lists
     * @param Request $request
     * @param MemberUser $memberUser
     * @return Paginate
     */
    public static function lists(Request $request, MemberUser $memberUser) {
        $where = " and b.member_user_id={$memberUser->id} and b.status=1 ";
        $results = new Paginate($request, ShopGoods::db(), 8);
        $results->setSelectCount("select count(a.id) as count from {table} a left join shangfan_member_focus_goods b on b.shop_goods_id=a.id where 1=1 {$where};");
        $results->setSelectResults("select a.*,b.id as member_focus_goods_id from {table} a left join shangfan_member_focus_goods b on b.shop_goods_id=a.id where 1=1 {$where} order by b.create_time desc,b.id desc;");
        $results->appends([]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $val->url = url('/shop/go/goods/' . $val->md5);
                $val->countSales = OrderGoods::countSales($val->md5);
            }
        }
        return $results;
    }

    /**
     * isFocusGoods
     * @param type $memberUserId
     * @param type $shopUserId
     * @return type
     */
    public static function isFocusGoods($memberUserId, $shopUserId, $shopGoodsId) {
        if (!$memberUserId || !$shopUserId) {
            return false;
        }
        $count = MemberFocusGoods::count("select count(id) as count from {table} where member_user_id={$memberUserId} and shop_user_id={$shopUserId} and shop_goods_id={$shopGoodsId} and status=1;");
        return $count ? true : false;
    }

    /**
     * detail
     * @param type $memberFocusGoodsId
     * @return type
     */
    public static function detail($memberFocusGoodsId) {
        return MemberFocusGoods::first("select * from {table} where id={$memberFocusGoodsId} and status=1;");
    }

    /**
     * del
     * @param MemberUser $memberUser
     * @param type $memberFocusGoodsId
     * @return type
     */
    public static function del(MemberUser $memberUser, $memberFocusGoodsId) {
        $memberFocusGoods = MemberFocusGoods::detail($memberFocusGoodsId);
        if (!$memberFocusGoods) {
            return statusFailure('未找到关注数据');
        }
        if ($memberUser->id != $memberFocusGoods->member_user_id) {
            return statusFailure('您没有权限');
        }
        $memberFocusGoods->status = 0;
        if (!$memberFocusGoods->save()) {
            return statusFailure('删除失败，请重或联系客服');
        }
        return statusSuccess('删除成功');
    }

}
