<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\MemberUser;
use framework\paginate\Paginate;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * MemberFocusShop
 */
class MemberFocusShop extends BaseModel {

    public $table = 'shangfan_member_focus_shop';
    public $key = 'id';

    /**
     * add
     * @param Request $request
     * @param MemberUser $memberUser
     * @return type
     */
    public static function add(Request $request, $memberUser) {
        if (!$memberUser) {
            return statusFailure('请先登录');
        }
        $shopUserId = intval($request->post('shopUserId', 0));
        if (!$shopUserId) {
            return statusFailure('缺少商家参数');
        }
        if (MemberFocusShop::isFocusShop($memberUser->id, $shopUserId)) {
            return statusSuccess('你已经关注该商家了');
        }
        $success = MemberFocusShop::insert([
                    'member_user_id' => $memberUser->id,
                    'shop_user_id' => $shopUserId,
                    'create_time' => time(),
                    'status' => 1
        ]);
        if (!$success) {
            return statusFailure('关注失败，请重试');
        }
        return statusSuccess('关注成功', ['insertId' => $success]);
    }

    /**
     * isFocusShop
     * @param type $memberUserId
     * @param type $shopUserId
     * @return type
     */
    public static function isFocusShop($memberUserId, $shopUserId) {
        if (!$memberUserId || !$shopUserId) {
            return false;
        }
        $count = MemberFocusShop::count("select count(id) as count from {table} where member_user_id={$memberUserId} and shop_user_id={$shopUserId} and status=1;");
        return $count ? true : false;
    }

    /**
     * lists
     * @param Request $request
     * @param MemberUser $memberUser
     * @return Paginate
     */
    public static function lists(Request $request, MemberUser $memberUser) {
        $where = " and b.member_user_id={$memberUser->id} and b.status=1 ";
        $results = new Paginate($request, ShopInfo::db(), 8);
        $results->setSelectCount("select count(a.id) as count from {table} a left join shangfan_member_focus_shop b on b.shop_user_id=a.shop_user_id where 1=1 {$where};");
        $results->setSelectResults("select a.*,b.id as member_focus_shop_id from {table} a left join shangfan_member_focus_shop b on b.shop_user_id=a.shop_user_id where 1=1 {$where} order by b.create_time desc,b.id desc;");
        $results->appends([]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $val->url = url('/shop/go/shop/' . $val->md5);
                $val->strCreateTime = MemberFocusShop::strCreateTime($val->create_time);
            }
        }
        return $results;
    }

    /**
     * detail
     * @param type $memberFocusShopId
     * @return type
     */
    public static function detail($memberFocusShopId) {
        return MemberFocusShop::first("select * from {table} where id={$memberFocusShopId} and status=1;");
    }

    /**
     * del
     * @param MemberUser $memberUser
     * @param type $memberFocusShopId
     * @return type
     */
    public static function del(MemberUser $memberUser, $memberFocusShopId) {
        $memberFocusShop = MemberFocusShop::detail($memberFocusShopId);
        if (!$memberFocusShop) {
            return statusFailure('未找到关注数据');
        }
        if ($memberUser->id != $memberFocusShop->member_user_id) {
            return statusFailure('您没有权限');
        }
        $memberFocusShop->status = 0;
        if (!$memberFocusShop->save()) {
            return statusFailure('删除失败，请重或联系客服');
        }
        return statusSuccess('删除成功');
    }

    /**
     * strCreateTime
     * @param type $createTime
     * @return type
     */
    public static function strCreateTime($createTime) {
        return date('Y/m/d H:i:s', $createTime);
    }

}
