<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\ShopGoods;
use shangfan\model\base\ShopGoodsOption;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * OrderGoods
 */
class OrderGoods extends BaseModel {

    public $table = 'shangfan_order_goods';
    public $key = 'id';

    /**
     * listsOrderGoods
     * @param type $orderNumber
     * @return type
     */
    public static function listsOrderGoods($orderNumber) {
        $orderGoods = OrderGoods::get("select * from {table} where order_number='{$orderNumber}';");
        if (!count($orderGoods)) {
            return [];
        }
        foreach ($orderGoods as &$val) {
            $shopGoods = ShopGoods::detailMd5($val->shop_goods_md5);
            $val->shopGoodsName = $shopGoods ? $shopGoods->name : '';
            list($mainOptionId, $noMainOptionId) = explode(',', $val->ids_option);
            $shopGoodsMainOption = ShopGoodsOption::detail($mainOptionId);
            $val->shopGoodsMainOptionName = $shopGoodsMainOption ? $shopGoodsMainOption->name : '';
            $val->shopGoodsMainOptionPicMini = $shopGoodsMainOption ? $shopGoodsMainOption->pic_mini : 0;
            $shopGoodsNoMainOption = ShopGoodsOption::detail($noMainOptionId);
            $val->shopGoodsNoMainOptionName = $shopGoodsNoMainOption ? $shopGoodsNoMainOption->name : '';
            $shopGoodsPrice = ShopGoodsPrice::goodsOptionPrice($val->ids_option);
            $val->shopGoodsOptionPrice = $shopGoodsPrice ? $shopGoodsPrice : 0;
            $val->shopGoodsOptionPriceTotal = bcadd($val->shopGoodsOptionPrice * $val->number, 0, 2);
            $val->goodsUrl = url('/shop/go/goods/' . $val->shop_goods_md5);
        }
        return $orderGoods;
    }

    /**
     * h5ListsOrderGoods
     * @param type $orderNumber
     * @return type
     */
    public static function h5ListsOrderGoods($orderNumber) {
        $orderGoods = OrderGoods::get("select * from {table} where order_number='{$orderNumber}';");
        if (!count($orderGoods)) {
            return [];
        }
        foreach ($orderGoods as &$val) {
            $shopGoods = ShopGoods::detailMd5($val->shop_goods_md5);
            $val->shopGoodsName = $shopGoods ? $shopGoods->name : '';
            list($mainOptionId, $noMainOptionId) = explode(',', $val->ids_option);
            $shopGoodsMainOption = ShopGoodsOption::detail($mainOptionId);
            $val->shopGoodsMainOptionName = $shopGoodsMainOption ? $shopGoodsMainOption->name : '';
            $val->shopGoodsMainOptionPicMini = $shopGoodsMainOption ? $shopGoodsMainOption->pic_mini : 0;
            $shopGoodsNoMainOption = ShopGoodsOption::detail($noMainOptionId);
            $val->shopGoodsNoMainOptionName = $shopGoodsNoMainOption ? $shopGoodsNoMainOption->name : '';
            $shopGoodsPrice = ShopGoodsPrice::goodsOptionPrice($val->ids_option);
            $val->shopGoodsOptionPrice = $shopGoodsPrice ? $shopGoodsPrice : 0;
            $val->shopGoodsOptionPriceTotal = bcadd($val->shopGoodsOptionPrice * $val->number, 0, 2);
            $val->goodsUrl = url('/h5/shop/goods/detail/' . $val->shop_goods_md5);
        }
        return $orderGoods;
    }

    /**
     * countOrderGoodsNumber
     * @param type $shopNumber
     * @return type
     */
    public static function countOrderGoodsNumber($shopNumber) {
        return OrderGoods::count("select count(id) as count from {table} where order_number='{$shopNumber}';");
    }

    /**
     * countSales
     * @param type $shopGoodsMd5
     * @return type
     */
    public static function countSales($shopGoodsMd5) {
        $stock = OrderGoods::first("select sum(number) countSales from {table} where shop_goods_md5='{$shopGoodsMd5}';");
        return $stock->countSales ? $stock->countSales : 0;
    }

}
