<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\ShopUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * ShopCategory
 */
class ShopCategory extends BaseModel {

    public $table = 'shangfan_shop_category';
    public $key = 'id';

    /**
     * addFirst
     * @param Request $request
     * @param ShopUser $shopUser
     * @return type
     */
    public static function addFirst(Request $request, ShopUser $shopUser) {
        if (!$request->post('name', '')) {
            return statusFailure('请输入商品大类名称');
        }
        $exist = ShopCategory::existCategory($request->post('title', ''), $shopUser->id);
        if ($exist) {
            return statusFailure('您已经添加了该大类，请检查');
        }
        $success = ShopCategory::insert([
                    'pid' => 0,
                    'name' => $request->post('name', ''),
                    'shop_user_id' => $shopUser->id,
                    'sort' => 0,
                    'create_time' => time(),
                    'status' => 1
        ]);
        if (!$success) {
            return statusFailure('添加商品大类失败，请重试或联系客服');
        }
        return statusSuccess('添加商品大类成功');
    }

    /**
     * addSecond
     * @param Request $request
     * @param ShopUser $shopUser
     * @return type
     */
    public static function addSecond(Request $request, ShopUser $shopUser) {
        if (!$request->post('pid', 0)) {
            return statusFailure('请选择商品大类');
        }
        if (!$request->post('name', '')) {
            return statusFailure('请输入商品小类名称');
        }
        $pid = intval($request->post('pid', 0));
        $exist = ShopCategory::existCategory($request->post('title', ''), $shopUser->id, $pid);
        if ($exist) {
            return statusFailure('您在该大类下已经添加了该小类，请检查');
        }
        $success = ShopCategory::insert([
                    'pid' => $pid,
                    'name' => $request->post('name', ''),
                    'shop_user_id' => $shopUser->id,
                    'sort' => 0,
                    'create_time' => time(),
                    'status' => 1
        ]);
        if (!$success) {
            return statusFailure('添加商品小类失败，请重试或联系客服');
        }
        return statusSuccess('添加商品小类成功');
    }

    /**
     * listFirst
     * @param Request $request
     * @param ShopUser $shopUser
     * @return type
     */
    public static function listFirst(Request $request, ShopUser $shopUser) {
        $results = ShopCategory::get("select * from {table} where shop_user_id={$shopUser->id} and pid=0 and status=1 order by sort asc;");
        if (!count($results)) {
            return [];
        }
        foreach ($results as &$val) {
            $val->countSecond = ShopCategory::countSecond($val->id);
        }
        return $results;
    }

    /**
     * listSecond
     * @param Request $request
     * @param ShopUser $shopUser
     * @param type $pid
     * @return type
     */
    public static function listSecond(Request $request, ShopUser $shopUser, $pid = 0, $shopInfo=null) {
        $listSecond = ShopCategory::get("select * from {table} where shop_user_id={$shopUser->id} and pid={$pid} and status=1 order by sort asc;");
        if(count($listSecond)){
            foreach ($listSecond as &$val){
                if($shopInfo){
                    $val->url = url("/shop/putaway/{$shopInfo->md5}/{$val->id}");
                }else{
                    $val->url = '';
                }
            }
        }
        return $listSecond;
    }

    /**
     * shopLists
     * @param Request $request
     * @param ShopUser $shopUser
     * @return type
     */
    public static function shopLists(Request $request, ShopUser $shopUser, $shopInfo=null) {
        $listFirst = ShopCategory::listFirst($request, $shopUser);
        if (!count($listFirst)) {
            return [];
        }
        foreach ($listFirst as &$val) {
            if($val->countSecond > 0){
                $val->listSecond = ShopCategory::listSecond($request, $shopUser, $val->id, $shopInfo);
            }else{
                $val->listSecond = [];
            }
            if($shopInfo){
                $val->url = url("/shop/putaway/{$shopInfo->md5}/{$val->id}");
            }else{
                $val->url = '';
            }
        }
        return $listFirst;
    }

    /**
     * edit
     * @param Request $reuqest
     * @param ShopUser $shopUser
     * @param type $id
     * @return type
     */
    public static function edit(Request $reuqest, ShopUser $shopUser, $id) {
        $shopCategory = ShopCategory::detail($id);
        if (!$shopCategory) {
            return statusFailure('未找到分类数据，请检查');
        }
        if ($shopUser->id != $shopCategory->shop_user_id) {
            return statusFailure('您没有权限');
        }
        if ($shopCategory->pid == 0) {
            if (!$reuqest->post('name', '')) {
                return statusFailure('请输入店铺大类名称');
            }
            $shopCategory->name = $reuqest->post('name', '');
            if (!$shopCategory->save()) {
                return statusFailure('修改失败，请重试或联系客服');
            }
            return statusSuccess('修改成功');
        }
        if (!$reuqest->post('pid', 0)) {
            return statusFailure('请选择店铺大类');
        }
        if (!$reuqest->post('name', '')) {
            return statusFailure('请输入店铺大类名称');
        }
        $shopCategory->pid = intval($reuqest->post('pid', 0));
        $shopCategory->name = $reuqest->post('name', '');
        if (!$shopCategory->save()) {
            return statusFailure('修改失败，请重试或联系客服');
        }
        return statusSuccess('修改成功');
    }

    /**
     * del
     * @param type $id
     * @param ShopUser $shopUser
     * @return type
     */
    public static function del($id, ShopUser $shopUser) {
        $shopCategory = ShopCategory::detail($id);
        if (!$shopCategory) {
            return statusFailure('未找到分类数据，请检查或联系客服');
        }
        if ($shopUser->id != $shopCategory->shop_user_id) {
            return statusFailure('您没有权限');
        }
        $shopCategory->status = 0;
        if (!$shopCategory->save()) {
            return statusFailure('删除失败，请重试或联系客服');
        }
        return statusSuccess('删除成功');
    }

    /**
     * existCategory
     * @param type $title
     * @param type $shopUserId
     * @return type
     */
    public static function existCategory($title, $shopUserId = 0, $pid = 0) {
        if ($pid > 0) {
            $count = ShopCategory::count("select count(id) as count from {table} where pid={$pid} and title='{$title}' and shop_user_id={$shopUserId};");
            return $count ? true : false;
        }
        $count = ShopCategory::count("select count(id) as count from {table} where title='{$title}' and shop_user_id={$shopUserId};");
        return $count ? true : false;
    }

    /**
     * secondArray
     * @param type $shopUserId
     * @return type
     */
    public static function secondArray($shopUserId) {
        $results = ShopCategory::get("select * from {table} where shop_user_id={$shopUserId} and pid=0 and status=1 order by sort asc;");
        if (!count($results)) {
            return [];
        }
        $data = [];
        foreach ($results as $val) {
            $data[$val->id] = $val->name;
        }
        return $data;
    }

    /**
     * countSecond
     * @param type $pid
     * @return type
     */
    public static function countSecond($pid) {
        return ShopCategory::count("select count(id) as count from {table} where pid={$pid} and status=1;");
    }

    /**
     * detail
     * @param type $id
     * @return type
     */
    public static function detail($id) {
        return ShopCategory::first("select * from {table} where id={$id} and status=1;");
    }

    /**
     * ajaxLevel
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public static function ajaxLevel(Request $request, $pid = 0) {
        $ajaxLists = ShopCategory::ajaxLists($request, $pid);
        if (!count($ajaxLists)) {
            return statusSuccess();
        }
        $data = [];
        foreach ($ajaxLists as $val) {
            $data[] = [
                'id' => $val->id,
                'name' => $val->name,
            ];
        }
        return statusSuccess('', $data);
    }

    /**
     * ajaxLists
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public static function ajaxLists(Request $request, $pid = 0) {
        $results = ShopCategory::get("select * from {table} where pid={$pid} and status=1;");
        if (!count($results)) {
            return [];
        }
        return $results;
    }

    /**
     * strName
     * @param type $shopCategoryId
     * @return string
     */
    public static function strName($shopCategoryId) {
        $shopCategory = ShopCategory::detail($shopCategoryId);
        if (!$shopCategory) {
            return '';
        }
        return $shopCategory->name;
    }

}
