<?php

namespace shangfan\model\base;

use framework\Request;
use framework\paginate\Paginate;
use shangfan\model\base\Stock;
use shangfan\model\base\OrderGoods;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * ShopGoods
 */
class ShopGoods extends BaseModel {

    public $table = 'shangfan_shop_goods';
    public $key = 'id';

    /**
     * lists
     * @param Request $request
     * @param type $shopUser
     * @return Paginate
     */
    public static function lists(Request $request, $shopUser) {
        $where = " shop_user_id={$shopUser->id} and status=1 ";
        $results = new Paginate($request, ShopGoods::db(), 10);
        $results->setSelectCount("select count(id) as count from {table} where {$where} order by create_time desc,id desc;");
        $results->setSelectResults("select * from {table} where {$where} order by create_time desc,id desc;");
        $results->appends([
                //'type' => $request->get('type', 0),
        ]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $shopGoodsCoverPics = ShopGoodsImages::getShopGoodsCoverPics($val->id);
                $val->picMini = $shopGoodsCoverPics->pic_mini;
                $val->mallCategoryName = MallCategory::strName($val->mall_category_id);
                $val->shopCategoryName = ShopCategory::strName($val->shop_category_id);
                $val->price_member = ShopGoods::strPriceMember($val->price_member);
                $val->strIsPutway = ShopGoods::strIsPutway($val->is_putaway);
                $val->strIsPutwayMall = ShopGoods::strIsPutwayMall($val->is_putaway_mall);
                $val->strH5IsPutaway = ShopGoods::strH5IsPutaway($val->h5_is_putaway);
                $val->strH5IsPutawayMall = ShopGoods::strH5IsPutawayMall($val->h5_is_putaway_mall);
                $val->url = url('/shop/go/goods/' . $val->md5);
            }
        }
        return $results;
    }

    /**
     * step1
     * @param Request $request
     * @param type $shopUser
     * @return type
     */
    public static function step1(Request $request, $shopUser) {
        $mallCategoryPid = intval($request->post('mall_category_pid', 0));
        if (!$mallCategoryPid) {
            return statusFailure('请选择要发布到的商城大类');
        }
        $mallCategorySid = intval($request->post('mall_category_sid', 0));
        if (!$mallCategorySid) {
            return statusFailure('请选择要发布到的商城大类');
        }
        $mallCategoryId = intval($request->post('mall_category_id', 0));
        if (!$mallCategoryId) {
            return statusFailure('请选择要发布到的商城大类');
        }
        $shopCategoryPid = intval($request->post('shop_category_pid', 0));
        if (!$shopCategoryPid) {
            return statusFailure('请选择要发布到的店铺大类');
        }
        $shopCategoryId = intval($request->post('shop_category_id', 0));
        if (!$shopCategoryId) {
            return statusFailure('请选择要发布到的店铺小类');
        }
        $name = trim($request->post('name', ''));
        if (!$name) {
            return statusFailure('请输入商品名称');
        }
        $priceMarket = bcadd($request->post('price_market', 0), 0, 2);
        if ($priceMarket < 0) {
            $priceMarket = 0;
        }
        $priceMember = bcadd($request->post('price_member', 0), 0, 2);
        if ($priceMember < 0) {
            $priceMember = 0;
        }
        $goodsId = ShopGoods::insert([
                    'shop_user_id' => $shopUser->id,
                    'name' => $name,
                    'mall_category_pid' => $mallCategoryPid,
                    'mall_category_sid' => $mallCategorySid,
                    'mall_category_id' => $mallCategoryId,
                    'shop_category_pid' => $shopCategoryPid,
                    'shop_category_id' => $shopCategoryId,
                    'price_market' => $priceMarket,
                    'price_member' => $priceMember,
                    'create_time' => time(),
                    'status' => 1,
        ]);
        if (!$goodsId) {
            return statusFailure('添加商品基础信息失败，请重试或联系客服');
        }
        $shopGoods = ShopGoods::detail($goodsId);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据，请重试或联系客服');
        }
        $shopGoods->md5 = createMd5($shopGoods->id);
        $shopGoods->save();
        if (!$shopGoods) {
            return statusFailure('更新商品序列失败，请重试或联系客服');
        }
        return statusSuccess('添加商品基础信息成功', ['md5' => $shopGoods->md5]);
    }

    /**
     * step1Edit
     * @param Request $request
     * @param type $shopUser
     * @return type
     */
    public static function step1Edit(Request $request, $shopUser, $md5) {
        $mallCategoryPid = intval($request->post('mall_category_pid', 0));
        if (!$mallCategoryPid) {
            return statusFailure('请选择要发布到的商城大类');
        }
        $mallCategorySid = intval($request->post('mall_category_sid', 0));
        if (!$mallCategorySid) {
            return statusFailure('请选择要发布到的商城大类');
        }
        $mallCategoryId = intval($request->post('mall_category_id', 0));
        if (!$mallCategoryId) {
            return statusFailure('请选择要发布到的商城大类');
        }
        $shopCategoryPid = intval($request->post('shop_category_pid', 0));
        if (!$shopCategoryPid) {
            return statusFailure('请选择要发布到的店铺大类');
        }
        $shopCategoryId = intval($request->post('shop_category_id', 0));
        if (!$shopCategoryId) {
            return statusFailure('请选择要发布到的店铺小类');
        }
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据');
        }
        if ($shopGoods->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        $name = trim($request->post('name', ''));
        if (!$name) {
            return statusFailure('请输入商品名称');
        }
        $priceMarket = bcadd($request->post('price_market', 0), 0, 2);
        if ($priceMarket < 0) {
            $priceMarket = 0;
        }
        $priceMember = bcadd($request->post('price_member', 0), 0, 2);
        if ($priceMember < 0) {
            $priceMember = 0;
        }
        $fill = [
            'name' => $name,
            'mall_category_pid' => $mallCategoryPid,
            'mall_category_sid' => $mallCategorySid,
            'mall_category_id' => $mallCategoryId,
            'shop_category_pid' => $shopCategoryPid,
            'shop_category_id' => $shopCategoryId,
            'price_market' => $priceMarket,
            'price_member' => $priceMember,
        ];
        if (!$shopGoods->md5) {
            $fill['md5'] = createMd5($shopGoods->id);
        }
        $shopGoods->fill($fill);
        if (!$shopGoods->save()) {
            return statusFailure('修改商品基础信息失败，请重试或联系客服');
        }
        return statusSuccess('修改商品基础信息成功', ['md5' => $md5]);
    }

    /**
     * step3
     * @param Request $request
     * @param type $shopUser
     * @return type
     */
    public static function step3(Request $request, $shopUser, $shopGoodsId) {
        if (!$shopGoodsId) {
            return statusFailure('缺少商品ID参数，请重试或联系客服');
        }
        $title = trim($request->post('title', ''));
        if (!$title) {
            return statusFailure('请输入商品名称');
        }
        $shopGoods = ShopGoods::detail($shopGoodsId);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据，请重试或联系客服');
        }
        if ($shopGoods->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        return ShopGoodsSelect::add($request, $shopUser, $shopGoodsId);
    }

    /**
     * del
     * @param type $shopUser
     * @param type $md5
     * @return type
     */
    public static function del(ShopUser $shopUser, $md5) {
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据');
        }
        if ($shopGoods->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        $shopGoods->status = 0;
        if (!$shopGoods->save()) {
            return statusFailure('删除失败，请重或联系客服');
        }
        return statusSuccess('删除成功');
    }

    /**
     * merchantUpdatePutawayStatus
     * @param ShopUser $shopUser
     * @param type $md5
     * @param type $field
     * @param type $value
     * @return type
     */
    public static function merchantUpdatePutawayStatus(ShopUser $shopUser, $md5, $field, $value) {
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据');
        }
        if ($shopGoods->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        $shopGoods->$field = $value;
        if (!$shopGoods->save()) {
            if ($value == 0) {
                return statusFailure('下架失败，请重或联系客服');
            }
            if ($value == 1) {
                return statusFailure('上架失败，请重或联系客服');
            }
        }
        return statusSuccess(($value == 1 ? '上架成功' : '下架成功'));
    }

    /**
     * adminUpdatePutawayStatus
     * @param type $md5
     * @param type $field
     * @param type $value
     * @return type
     */
    public static function adminUpdatePutawayStatus($md5, $field, $value) {
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据');
        }
        $shopGoods->$field = $value;
        if (!$shopGoods->save()) {
            if ($value == 0) {
                return statusFailure('下架失败，请重或联系客服');
            }
            if ($value == 1) {
                return statusFailure('上架失败，请重或联系客服');
            }
        }
        return statusSuccess(($value == 1 ? '上架成功' : '下架成功'));
    }

    /**
     * listsMallIndex
     * @param Request $request
     * @return type
     */
    public static function listsMallIndex(Request $request) {
        $mallCategory = MallCategory::lists();
        if (!count($mallCategory)) {
            return [];
        }
        foreach ($mallCategory as &$cat) {
            $shopGoodsLists = ShopGoods::get("select * from {table} where mall_category_pid={$cat->id} and status=1 and is_putaway=1 order by id desc limit 7;");
            if (count($shopGoodsLists)) {
                foreach ($shopGoodsLists as &$_val) {
                    $_val->url = url('/shop/goods/' . $_val->md5);
                }
            }
            $cat->shopGoodsLists = $shopGoodsLists;
            if (!count($cat->shopGoodsLists)) {
                continue;
            }
        }
        return $mallCategory;
    }

    /**
     * listsAdmin
     * @param Request $request
     * @return type
     */
    public static function listsAdmin(Request $request) {
        $where = " 1=1 and status=1 ";
        $results = new Paginate($request, ShopGoods::db(), 10);
        $results->setSelectCount("select count(id) as count from {table} where {$where} order by create_time desc,id desc;");
        $results->setSelectResults("select * from {table} where {$where} order by create_time desc,id desc;");
        $results->appends([
                //'type' => $request->get('type', 0),
        ]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $val->mallCategoryName = MallCategory::strName($val->mall_category_id);
                $val->shopCategoryName = ShopCategory::strName($val->shop_category_id);
                $val->price_member = ShopGoods::strPriceMember($val->price_member);
                $val->strIsPutwayMall = ShopGoods::strIsPutwayMall($val->is_putaway_mall);
                $val->strH5IsPutawayMall = ShopGoods::strH5IsPutawayMall($val->h5_is_putaway_mall);
                $val->strIsPutway = ShopGoods::strIsPutway($val->is_putaway);
                $val->strH5IsPutaway = ShopGoods::strH5IsPutaway($val->h5_is_putaway);
                $val->countStockSurplus = Stock::countSurplusGoodsId($val->id);
            }
        }
        return $results;
    }

    /**
     * listsShopHomeIndex
     * @param Request $request
     * @return type
     */
    public static function listsShopHomeIndex(Request $request) {
        $shopGoodsLists = ShopGoods::get("select * from {table} where status=1 and is_putaway=1 order by id desc limit 12;");
        if (count($shopGoodsLists)) {
            foreach ($shopGoodsLists as &$val) {
                $val->url = url('/shop/go/goods/' . $val->md5);
                $val->countSales = OrderGoods::countSales($val->md5);
            }
        }
        return $shopGoodsLists;
    }

    /**
     * listsShopHomePutaway
     * @param Request $request
     * @return type
     */
    public static function listsShopHomePutaway(Request $request, $shopCategoryId = 0) {
        $where = " and status=1 and is_putaway=1 ";
        if ($shopCategoryId > 0) {
            $shopCategory = ShopCategory::detail($shopCategoryId);
            if ($shopCategory) {
                if ($shopCategory->pid == 0) {
                    $where .= " and shop_category_pid={$shopCategoryId} ";
                }
                if ($shopCategory->pid > 0) {
                    $where .= " and shop_category_id={$shopCategoryId} ";
                }
            }
        }
        $keywords = trim($request->get('keywords', ''));
        if($keywords){
            $where .= " and name like '%{$keywords}%' ";
        }
        $results = new Paginate($request, ShopGoods::db(), 24);
        $results->setSelectCount("select count(id) as count from {table} where 1=1 {$where} order by id desc;");
        $results->setSelectResults("select * from {table} where 1=1 {$where} order by id desc;");
        $results->appends([
            'mallCategoryId' => $request->get('mallCategoryId', 0),
        ]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $val->url = url('/shop/goods/' . $val->md5);
                $val->countSales = OrderGoods::countSales($val->md5);
            }
        }
        return $results;
    }

    /**
     * h5Lists
     * @param Request $request
     * @return type
     */
    public static function h5Lists(Request $request, $mallCategoryId) {
        $where = " 1=1 and mall_category_id={$mallCategoryId} and h5_is_putaway=1 and h5_is_putaway_mall=1 ";
        $results = new Paginate($request, ShopGoods::db(), 10);
        $results->setSelectCount("select count(id) count from {table} where {$where} order by create_time desc;");
        $results->setSelectResults("select * from {table} where {$where} order by create_time desc;");
        $results->appends([
                //'type' => $request->get('type', 0),
        ]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $val->url = url('/h5/shop/goods/detail/' . $val->md5);
            }
        }
        return $results;
    }

    /**
     * h5Search
     * @param Request $request
     * @return type
     */
    public static function h5Search(Request $request) {
        $where = " 1=1 and h5_is_putaway=1 and h5_is_putaway_mall=1 ";
        $keywords = trim($request->get('keywords', ''));
        if ($keywords) {
            $where .= " and name like '%{$keywords}%' ";
        }
        $results = new Paginate($request, ShopGoods::db(), 10);
        $results->setSelectCount("select * from {table} where {$where} order by create_time desc;");
        $results->setSelectResults("select * from {table} where {$where} order by create_time desc;");
        $results->appends([
            'keywords' => $keywords,
        ]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $val->url = url('/h5/shop/goods/detail/' . $val->md5);
            }
        }
        return $results;
    }

    /**
     * listsMallIndex
     * @param Request $request
     * @return type
     */
    public static function listsMallCategory(Request $request, $mallCategoryId) {
        $results = new Paginate($request, ShopGoods::db(), 24);
        $results->setSelectCount("select count(id) as count from {table} where mall_category_id={$mallCategoryId} and status=1 and is_putaway=1 order by id desc;");
        $results->setSelectResults("select * from {table} where mall_category_id={$mallCategoryId} and status=1 and is_putaway=1 order by id desc;");
        $results->appends([
//            'type' => $request->get('type', 0),
        ]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $val->url = url('/shop/goods/' . $val->md5);
                $val->countSales = OrderGoods::countSales($val->md5);
            }
        }
        return $results;
    }

    /**
     * h5ListsMallIndexNew
     * @param Request $request
     * @return type
     */
    public static function h5ListsMallIndexNew(Request $request) {
        $mallCategory = ShopGoods::get("select * from {table} where status=1 and h5_is_putaway=1 && h5_is_putaway_mall order by id desc limit 8;");
        if (!count($mallCategory)) {
            return [];
        }
        foreach ($mallCategory as &$val) {
            $val->url = url('/h5/shop/goods/detail/' . $val->md5);
        }
        return $mallCategory;
    }

    /**
     * h5ListsLike
     * @param Request $request
     * @return type
     */
    public static function h5ListsLike(Request $request, $mallCategoryId) {
        $mallCategoryPid = MallCategory::level1CategoryId($mallCategoryId);
        if (!$mallCategoryPid) {
            return [];
        }
        $mallCategory = ShopGoods::get("select * from {table} where mall_category_pid={$mallCategoryPid} and status=1 and h5_is_putaway=1 && h5_is_putaway_mall order by rand() limit 12;");
        if (!count($mallCategory)) {
            return [];
        }
        foreach ($mallCategory as &$val) {
            $val->url = url('/h5/shop/goods/detail/' . $val->id);
        }
        return $mallCategory;
    }

    /**
     * h5ListsMallIndexHot
     * @param Request $request
     * @return type
     */
    public static function h5ListsMallIndexHot(Request $request) {
        $shopGoods = ShopGoods::get("select * from {table} where h5_is_putaway=1 and h5_is_putaway_mall=1 order by rand() limit 8;");
        if (!count($shopGoods)) {
            return [];
        }
        foreach ($shopGoods as &$val) {
            $val->url = url('/h5/shop/goods/detail/' . $val->md5);
        }
        return $shopGoods;
    }

    /**
     * detail
     * @param type $shopGoodsId
     * @return type
     */
    public static function detail($shopGoodsId) {
        $detail = ShopGoods::first("select * from {table} where id={$shopGoodsId} and status=1;");
        if ($detail && !$detail->md5) {
            $detail->md5 = createMd5($detail->id);
            $detail->save();
        }
        return $detail;
    }

    /**
     * detailMd5
     * @param type $md5
     * @return type
     */
    public static function detailMd5($md5) {
        $detail = ShopGoods::first("select * from {table} where md5='{$md5}' and status=1;");
        if ($detail && !$detail->md5) {
            $detail->md5 = createMd5($detail->id);
            $detail->save();
        }
        return $detail;
    }

    /**
     * countPidGoodsNumber
     * @param type $categoryId
     * @return type
     */
    public static function countCategoryGoodsNumber($categoryId) {
        return ShopGoods::count("select count(id) as count from {table} where mall_category_pid={$categoryId} and status=1;");
    }

    /**
     * countSidGoodsNumber
     * @param type $sid
     * @return type
     */
    public static function countSidGoodsNumber($sid) {
        return ShopGoods::count("select count(id) as count from {table} where mall_category_sid={$sid} and status=1;");
    }

    /**
     * countIdGoodsNumber
     * @param type $id
     * @return type
     */
    public static function countIdGoodsNumber($id) {
        return ShopGoods::count("select count(id) as count from {table} where mall_category_id={$id} and status=1;");
    }

    /**
     * strPriceMember
     * @param type $priceMember
     * @return type
     */
    public static function strPriceMember($priceMember) {
        return bcadd($priceMember, 0, 2);
    }

    /**
     * strIsPutway
     * @param type $isPutway
     * @return type
     */
    public static function strIsPutway($isPutway) {
        return $isPutway ? '店铺上架' : '店铺下架';
    }

    /**
     * strIsPutway
     * @param type $isPutway
     * @return type
     */
    public static function strIsPutwayMall($isPutway) {
        if ($isPutway == 2) {
            return '商城审核';
        }
        return $isPutway ? '商城上架' : '商城下架';
    }

    /**
     * strH5IsPutaway
     * @param type $h5IsPutaway
     * @return type
     */
    public static function strH5IsPutaway($h5IsPutaway) {
        return $h5IsPutaway ? '店铺上架' : '店铺下架';
    }

    /**
     * strH5IsPutawayMall
     * @param type $h5IsPutawayMall
     * @return type
     */
    public static function strH5IsPutawayMall($h5IsPutawayMall) {
        if ($h5IsPutawayMall == 2) {
            return '商城审核';
        }
        return $h5IsPutawayMall ? '商城上架' : '商城下架';
    }

}
