<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\ShopUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * ShopGoodsImages
 */
class ShopGoodsImages extends BaseModel {

    public $table = 'shangfan_shop_goods_images';
    public $key = 'id';

    /**
     * addGoodsDetailPic
     * @param ShopUser $shopUser
     * @param type $shopGoodsId
     * @param type $picSrc
     * @param type $picMini
     * @param type $picBig
     * @return boolean
     */
    public static function addGoodsDetailPic(ShopUser $shopUser, $shopGoodsId, $picSrc, $picMini = '', $picBig = '') {
        if (!$shopUser || !$shopGoodsId || !$picSrc) {
            return false;
        }
        return ShopGoodsImages::insert([
                    'shop_user_id' => $shopUser->id,
                    'shop_goods_id' => $shopGoodsId,
                    'type' => 2,
                    'pic_src' => $picSrc,
                    'pic_mini' => $picMini,
                    'create_time' => time(),
                    'status' => 1
        ]);
    }

    /**
     * addH5GoodsDetailPic
     * @param ShopUser $shopUser
     * @param type $shopGoodsId
     * @param type $picSrc
     * @param type $picMini
     * @param type $picBig
     * @return boolean
     */
    public static function addH5GoodsDetailPic(ShopUser $shopUser, $shopGoodsId, $picSrc, $picMini = '', $picBig = '') {
        if (!$shopUser || !$shopGoodsId || !$picSrc) {
            return false;
        }
        return ShopGoodsImages::insert([
                    'shop_user_id' => $shopUser->id,
                    'shop_goods_id' => $shopGoodsId,
                    'type' => 12,
                    'pic_src' => $picSrc,
                    'pic_mini' => $picMini,
                    'create_time' => time(),
                    'status' => 1
        ]);
    }

    /**
     * updateGoodsCoverPic
     * @param ShopUser $shopUser
     * @param type $shopGoodsId
     * @param type $picSrc
     * @param type $picMini
     * @param type $picBig
     * @return boolean
     */
    public static function updateGoodsCoverPic(ShopUser $shopUser, $shopGoodsId, $picSrc, $picMini = '') {
        if (!$shopUser || !$shopGoodsId || !$picSrc) {
            return false;
        }
        $shopGoods = ShopGoods::detail($shopGoodsId);
        if (!$shopGoods) {
            return false;
        }
        $unlinkPicSrc = rootPath() . $shopGoods->cover_src;
        if (file_exists($unlinkPicSrc)) {
            @unlink($unlinkPicSrc);
        }
        $unlinkPicMini = rootPath() . $shopGoods->cover_mini;
        if (file_exists($unlinkPicMini)) {
            @unlink($unlinkPicMini);
        }
        $shopGoods->fill([
            'cover_src' => $picSrc,
            'cover_mini' => $picMini,
        ]);
        return $shopGoods->save();
    }

    /**
     * addGoodsOptionPic
     * @param ShopUser $shopUser
     * @param type $goodsOptionId
     * @param type $picSrc
     * @param type $picMini
     * @param type $picBig
     * @return boolean
     */
    public static function addGoodsOptionPic(ShopUser $shopUser, $goodsOptionId, $picSrc, $picMini = '') {
        if (!$shopUser || !$goodsOptionId || !$picSrc) {
            return false;
        }
        $shopGoodsOption = ShopGoodsOption::detail($goodsOptionId);
        if (!$shopGoodsOption) {
            return false;
        }
        $unlinkPicSrc = rootPath() . $shopGoodsOption->pic_src;
        if (file_exists($unlinkPicSrc)) {
            @unlink($unlinkPicSrc);
        }
        $unlinkPicMini = rootPath() . $shopGoodsOption->pic_mini;
        if (file_exists($unlinkPicMini)) {
            @unlink($unlinkPicMini);
        }
        $shopGoodsOption->fill([
            'pic_src' => $picSrc,
            'pic_mini' => $picMini,
        ]);
        return $shopGoodsOption->save();
    }

    /**
     * picSort
     * @param Request $request
     * @param type $shopUser
     * @return type
     */
    public static function picSort(Request $request, $shopUser) {
        $goodsId = intval($request->post('goodsId', 0));
        if (!$goodsId) {
            return statusFailure('排序失败，缺少商品ID参数');
        }
        $goodsImagesId = intval($request->post('goodsImagesId', 0));
        if (!$goodsImagesId) {
            return statusFailure('排序失败，缺少图片ID参数');
        }
        $sort = intval($request->post('sort', 0));
        if (!$sort) {
            return statusFailure('排序失败，请输入有效排序数字');
        }
        $shopGoodsImages = ShopGoodsImages::detail($goodsImagesId);
        if (!$shopGoodsImages) {
            return statusFailure('未找到数据，请重试');
        }
        if ($shopGoodsImages->shop_user_id != $shopUser->id) {
            return statusFailure('对不起！您没有权限');
        }
        if ($shopGoodsImages->sort != $sort) {
            $shopGoodsImages->sort = $sort;
            if (!$shopGoodsImages->save()) {
                return statusFailure('排序失败，请重试');
            }
        }
        return statusSuccess('排序成功');
    }

    /**
     * picDel
     * @param Request $request
     * @param type $shopUser
     * @return type
     */
    public static function picDel(Request $request, $shopUser, $goodsImagesId) {
        if (!$goodsImagesId) {
            return statusFailure('删除失败，缺少图片ID参数');
        }
        $shopGoodsImages = ShopGoodsImages::detail($goodsImagesId);
        if (!$shopGoodsImages) {
            return statusFailure('未找到数据，请重试');
        }
        if ($shopGoodsImages->shop_user_id != $shopUser->id) {
            return statusFailure('对不起！您没有权限');
        }
        $unlinkPicSrc = rootPath() . $shopGoodsImages->pic_src;
        if (file_exists($unlinkPicSrc)) {
            @unlink($unlinkPicSrc);
        }
        $unlinkPicMini = rootPath() . $shopGoodsImages->pic_mini;
        if (file_exists($unlinkPicMini)) {
            @unlink($unlinkPicMini);
        }
        $shopGoodsImages->status = 0;
        if (!$shopGoodsImages->save()) {
            return statusFailure('删除失败，请重试');
        }
        return statusSuccess('删除成功');
    }

    /**
     * getShopGoodsPics
     * @param type $shopGoodsId
     * @return type
     */
    public static function getShopGoodsCoverPics($shopGoodsId) {
        return ShopGoodsImages::first("select * from {table} where shop_goods_id={$shopGoodsId} and type=1 and status=1 order by sort asc,create_time desc;");
    }

    /**
     * getShopGoodsDetailPics
     * @param type $shopGoodsId
     * @return type
     */
    public static function getShopGoodsDetailPics($shopGoodsId) {
        return ShopGoodsImages::get("select * from {table} where shop_goods_id={$shopGoodsId} and type=2 and status=1 order by sort asc,create_time desc;");
    }

    /**
     * getH5ShopGoodsDetailPics
     * @param type $shopGoodsId
     * @return type
     */
    public static function getH5ShopGoodsDetailPics($shopGoodsId) {
        return ShopGoodsImages::get("select * from {table} where shop_goods_id={$shopGoodsId} and type=12 and status=1 order by sort asc,create_time desc;");
    }

    /**
     * detail
     * @param type $goodsImagesId
     * @return type
     */
    public static function detail($goodsImagesId) {
        return ShopGoodsImages::first("select * from {table} where id={$goodsImagesId} and status=1;");
    }

}
