<?php

namespace shangfan\model\base;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 支付流水
 */
class ShopPayRecord extends BaseModel {

    public $table = 'shangfan_shop_pay_record';
    public $key = 'id';

    /**
     * add
     * @param type $shopUserId
     * @param type $rmb
     * @return type
     */
    public static function add($shopUserId, $rmb, $orderNumber = '') {
        return ShopPayRecord::writeRecord(1, $shopUserId, $rmb, $orderNumber);
    }

    /**
     * reduce
     * @param type $shopUserId
     * @param type $rmb
     * @return type
     */
    public static function reduce($shopUserId, $rmb, $orderNumber = '') {
        return ShopPayRecord::writeRecord(2, $shopUserId, $rmb, $orderNumber);
    }

    /**
     * writeRecord
     * @param type $type
     * @param type $shopUserId
     * @param type $rmb
     * @param type $channelTypeStr
     * @param type $channelNumber
     * @return type
     */
    public static function writeRecord($type, $shopUserId, $rmb, $orderNumber = '') {
        $success = ShopPayRecord::insert([
                    'shop_user_id' => $shopUserId,
                    'type' => $type,
                    'rmb' => $rmb,
                    'order_number' => $orderNumber,
                    'create_time' => time(),
        ]);
        if (!$success) {
            if ($type == 1) {
                return statusFailure('入帐失败，请重试');
            }
            if ($type == 2) {
                return statusFailure('出帐失败，请重试');
            }
            return statusFailure('操作失败，请重试');
        }
        if ($type == 1) {
            return statusSuccess('入帐成功');
        }
        if ($type == 2) {
            return statusSuccess('出帐成功');
        }
        return statusSuccess('操作成功');
    }

    /**
     * countMemberRecordAdd
     * @param type $shopUserId
     * @return int
     */
    public static function countMemberRecordAdd($shopUserId) {
        $payRecord = ShopPayRecord::first("select sum(rmb) rmb from {table} where member_user_id={$shopUserId} and type=1;");
        if (!$payRecord) {
            return 0;
        }
        return $payRecord->rmb;
    }

    /**
     * countMemberRecordReduce
     * @param type $shopUserId
     * @return int
     */
    public static function countMemberRecordReduce($shopUserId) {
        $payRecord = ShopPayRecord::first("select sum(rmb) rmb from {table} where member_user_id={$shopUserId} and type=2;");
        if (!$payRecord) {
            return 0;
        }
        return $payRecord->rmb;
    }

    /**
     * countMemberRecordSurplus
     * @param type $shopUserId
     * @return type
     */
    public static function countMemberRecordSurplus($shopUserId) {
        $rmb = ShopPayRecord::countMemberRecordAdd($shopUserId) - ShopPayRecord::countMemberRecordReduce($shopUserId);
        return bcadd($rmb, 0, 2);
    }

}
