<?php

namespace shangfan\model\base;

use shangfan\model\base\ShopGoods;
use shangfan\model\base\ShopGoodsPrice;
use shangfan\model\base\MemberUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * MallSearch
 */
class ShopShopingcartOption extends BaseModel {

    public $table = 'shangfan_shop_shopingcart_option';
    public $key = 'id';

    /**
     * listsShopUserId
     * @param type $shopUserId
     * @return type
     */
    public static function listsShopUserId($shopUserId) {
        $shopShopingcartOption = ShopShopingcartOption::get("select * from {table} where shop_user_id={$shopUserId} and is_order=0 and status=1;");
        if (!count($shopShopingcartOption)) {
            return $shopShopingcartOption;
        }
        foreach ($shopShopingcartOption as &$val) {
            $val->url = url('/h5/shop/goods/detail/' . $val->shop_goods_md5);
            $shopGoods = ShopGoods::detailMd5($val->shop_goods_md5);
            $val->shopGoodsName = $shopGoods ? $shopGoods->name : '';
            list($mainOptionId, $noMainOptionId) = explode(',', $val->ids_option);
            $shopGoodsMainOption = ShopGoodsOption::detail($mainOptionId);
            $val->shopGoodsMainOptionName = $shopGoodsMainOption ? $shopGoodsMainOption->name : '';
            $val->shopGoodsMainOptionPicMini = $shopGoodsMainOption ? $shopGoodsMainOption->pic_mini : 0;
            $shopGoodsNoMainOption = ShopGoodsOption::detail($noMainOptionId);
            $val->shopGoodsNoMainOptionName = $shopGoodsNoMainOption ? $shopGoodsNoMainOption->name : '';
            $shopGoodsPrice = ShopGoodsPrice::detailIdsOption($val->ids_option);
            $val->shopGoodsOptionPrice = $shopGoodsPrice ? $shopGoodsPrice->price : 0;
            $val->shopGoodsOptionPriceTotal = bcadd($val->shopGoodsOptionPrice * $val->number, 0, 2);
        }
        return $shopShopingcartOption;
    }

    /**
     * updateNumber
     * @param type $shopingcartOptionId
     * @param type $number
     * @return type
     */
    public static function updateNumber($memberUser, $shopingcartOptionId, $number) {
        if(!$memberUser){
            return statusFailure('请先登录');
        }
        if (!$number) {
            return statusFailure('数量不能少于1');
        }
        $shopingcartOption = ShopShopingcartOption::detail($shopingcartOptionId);
        if (!$shopingcartOption) {
            return statusFailure('未找到规格数据');
        }
        if ($shopingcartOption->member_user_id != $memberUser->id) {
            return statusFailure('您没有权限');
        }
        $shopingcartOption->number = $number;
        if (!$shopingcartOption->save()) {
            return statusFailure('更新数量失败');
        }
        return statusSuccess();
    }

    /**
     * detail
     * @param type $id
     * @return type
     */
    public static function detail($id) {
        return ShopShopingcartOption::first("select * from {table} where id={$id};");
    }

}
