<?php

namespace shangfan\model\base;

use framework\Request;
use framework\Auth;
use framework\paginate\Paginate;
use shangfan\model\base\MemberFocusShop;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商家管理
 */
class ShopUser extends BaseModel {

    public $table = 'shangfan_shop_user';
    public $key = 'id';

    /**
     * login
     * @param Request $request
     * @return type
     */
    public static function login(Request $request) {
        $user = trim($request->post('user', ''));
        $passwd = trim($request->post('passwd', ''));
        if (!$user) {
            return statusFailure('请输入手机号');
        }
        if (!$passwd) {
            return statusFailure('请输入密码');
        }
        $shopUser = ShopUser::detailUser($user);
        if (!$shopUser) {
            return statusFailure('账号错误，请检查');
        }
        if ($shopUser->passwd != md5($passwd)) {
            return statusFailure('密码错误，请检查');
        }
        if (!Auth::refresh('merchant', (array) $shopUser->attribute)) {
            return statusFailure('登录失败，请重试');
        }
        return statusSuccess('登录成功');
    }

    /**
     * register
     * @param Request $request
     * @return type
     */
    public static function register(Request $request) {
        $name = trim($request->post('name', ''));
        $user = trim($request->post('user', ''));
        $passwd1 = trim($request->post('passwd1', ''));
        $passwd2 = trim($request->post('passwd2', ''));
        if (!$name) {
            return statusFailure('请输入姓名');
        }
        if (!$user) {
            return statusFailure('请输入手机号');
        }
        if (!$passwd1) {
            return statusFailure('请输入密码');
        }
        if (!$passwd2) {
            return statusFailure('请再次输入密码');
        }
        if ($passwd1 != $passwd2) {
            return statusFailure('两次密码不一致，请检查');
        }
        $count = ShopUser::count("select count(id) as count from shangfan_shop_user where status=1 and user='{$user}';");
        if ($count) {
            return statusFailure('手机号已经存在，请换一个');
        }
        $insert = [
            'user' => $user,
            'name' => $name,
            'passwd' => md5($passwd1),
            'type' => 1,
            'rmb' => 0.00,
            'score' => 0.00,
            'create_time' => time(),
            'is_online' => 2,
        ];
        $success = ShopUser::insert($insert);
        if (!$success) {
            return statusFailure('创建商家账号失败，请重试或联系客服');
        }
        return statusSuccess('创建商家账号成功');
    }
    
    /**
     * password
     * @param Request $request
     * @param type $shopUser
     * @return type
     */
    public static function password(Request $request, $shopUser) {
        $password1 = trim($request->post('password1', ''));
        $password2 = trim($request->post('password2', ''));
        $password3 = trim($request->post('password3', ''));
        if (!$password1) {
            return statusFailure('请输入旧密码');
        }
        if (!$password2) {
            return statusFailure('请输入新密码');
        }
        if (!$password3) {
            return statusFailure('请再次输入新密码');
        }
        if ($shopUser->passwd != md5($password1)) {
            return statusFailure('旧密码错误，请检查');
        }
        if ($password2 != $password3) {
            return statusFailure('两次输入的新密码不一致，请检查');
        }
        $shopUser->passwd = md5($password2);
        if (!$shopUser->save()) {
            return statusFailure('修改密码失败，请重试');
        }
        Auth::remove('merchant');
        return statusSuccess('修改密码成功');
    }

    /**
     * listsAdmin
     * @param Request $request
     * @return type
     */
    public static function listsAdmin(Request $request) {
        $where = " 1=1 and a.status in (1,2) ";
        $results = new Paginate($request, ShopUser::db(), 10);
        $results->setSelectCount("select count(a.id) as count from {table} a left join shangfan_shop_info b on a.id=b.shop_user_id where {$where};");
        $results->setSelectResults("select a.*,b.md5 from {table} a left join shangfan_shop_info b on a.id=b.shop_user_id where {$where} order by a.create_time desc,a.id desc;");
        $results->appends([
                //'type' => $request->get('type', 0),
        ]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $val->strType = ShopUser::strType($val->type);
                $val->strStatus = ShopUser::strStatus($val->status);
                $val->strIsOnline = ShopUser::strIsOnline($val->is_online);
                $val->strShopInfoTitle = ShopUser::strShopInfoTitle($val->id);
                $val->strProvince = '-';
                $val->strCity = '-';
                $val->strCountry = '-';
                if ($val->province_id) {
                    $city = SystemCity::detail($val->province_id);
                    if ($city) {
                        $val->strProvince = $city->name;
                    }
                }
                if ($val->city_id) {
                    $city = SystemCity::detail($val->city_id);
                    if ($city) {
                        $val->strCity = $city->name;
                    }
                }
                if ($val->country_id) {
                    $city = SystemCity::detail($val->country_id);
                    if ($city) {
                        $val->strCountry = $city->name;
                    }
                }
            }
        }
        return $results;
    }

    /**
     * lock
     * @param type $shopUserId
     * @return type
     */
    public static function lock($shopUserId) {
        $shopUser = ShopUser::detail($shopUserId);
        if (!$shopUser) {
            return statusFailure('未找到店铺，请重试');
        }
        $shopUser->status = 2;
        if (!$shopUser->save()) {
            return statusFailure('账号锁定失败，请重试');
        }
        return statusSuccess('账号锁定成功');
    }

    /**
     * unlock
     * @param type $shopUserId
     * @return type
     */
    public static function unlock($shopUserId) {
        $shopUser = ShopUser::detail($shopUserId);
        if (!$shopUser) {
            return statusFailure('未找到店铺，请重试');
        }
        $shopUser->status = 1;
        if (!$shopUser->save()) {
            return statusFailure('账号解锁失败，请重试');
        }
        return statusSuccess('账号解锁成功');
    }

    /**
     * del
     * @param type $shopUserId
     * @return type
     */
    public static function del($shopUserId) {
        $shopUser = ShopUser::detail($shopUserId);
        if (!$shopUser) {
            return statusFailure('未找到店铺，请重试');
        }
        $shopUser->status = 0;
        if (!$shopUser->save()) {
            return statusFailure('账号删除失败，请重试');
        }
        return statusSuccess('账号删除成功');
    }

    /**
     * shopOnline
     * @param type $shopUserId
     * @return type
     */
    public static function shopOnline($shopUserId) {
        $shopUser = ShopUser::detail($shopUserId);
        if (!$shopUser) {
            return statusFailure('未找到商家信息，请重试');
        }
        $shopInfo = ShopInfo::detailShopUserId($shopUserId);
        if (!$shopInfo) {
            return statusFailure('未找到店铺信息，请重试');
        }
        $shopUser->is_online = 1;
        if (!$shopUser->save()) {
            return statusFailure('操作失败，请重试');
        }
        return statusSuccess('成功审核通过');
    }

    /**
     * shopOffline
     * @param type $shopUserId
     * @return type
     */
    public static function shopOffline($shopUserId) {
        $shopUser = ShopUser::detail($shopUserId);
        if (!$shopUser) {
            return statusFailure('未找到店铺，请重试');
        }
        $shopUser->is_online = 2;
        if (!$shopUser->save()) {
            return statusFailure('操作失败，请重试');
        }
        return statusSuccess('成功拒绝审核');
    }

    /**
     * countFocus
     * @param type $shopUserId
     * @return type
     */
    public static function countFocus($shopUserId) {
        return MemberFocusShop::count("select count(id) as count from {table} where shop_user_id={$shopUserId} and status=1;");
    }

    /**
     * countShopGoods
     * @param type $shopUserId
     * @return type
     */
    public static function countShopGoods($shopUserId) {
        return ShopGoods::count("select count(id) as count from {table} where shop_user_id={$shopUserId} and status=1;");
    }

    /**
     * strCountFocus
     * @param type $shopUserId
     * @return type
     */
    public static function strCountFocus($shopUserId) {
        $countFocus = ShopUser::countFocus($shopUserId);
        if ($countFocus < 10000) {
            return $countFocus;
        }
        return ($countFocus / 10000) . '万';
    }

    /**
     * strType
     * @param type $type
     * @return string
     */
    public static function strType($type) {
        if ($type == 1) {
            return '企业';
        }
        if ($type == 2) {
            return '个人';
        }
        return '-';
    }

    /**
     * strStatus
     * @param type $status
     * @return string
     */
    public static function strStatus($status) {
        if ($status == 1) {
            return '正常';
        }
        if ($status == 2) {
            return '锁定';
        }
        if ($status == 0) {
            return '删除';
        }
        return '-';
    }

    /**
     * strIsOnline
     * @param type $status
     * @return string
     */
    public static function strIsOnline($status) {
        if ($status == 0) {
            return '店铺关闭';
        }
        if ($status == 2) {
            return '等待审核';
        }
        if ($status == 1) {
            return '正常开业';
        }
        return '-';
    }

    /**
     * strShopInfoTitle
     * @param type $shopUserId
     * @return string
     */
    public static function strShopInfoTitle($shopUserId) {
        $shopInfo = ShopInfo::detailShopUserId($shopUserId);
        if (!$shopInfo) {
            return '-';
        }
        return $shopInfo->name;
    }

    /**
     * detail
     * @param type $id
     * @return type
     */
    public static function detail($id) {
        return ShopUser::first("select * from shangfan_shop_user where id={$id};");
    }

    /**
     * detailUser
     * @param type $user
     * @return type
     */
    public static function detailUser($user) {
        return ShopUser::first("select * from shangfan_shop_user where user='{$user}';");
    }

}
