<?php

namespace shangfan\model\base;

use framework\Request;
use framework\Auth;
use shangfan\model\base\SystemAdminUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * SystemAdminUser
 */
class SystemAdminUser extends BaseModel {

    public $table = 'shangfan_system_admin_user';
    public $key = 'id';

    /**
     * login
     * @param Request $request
     * @return type
     */
    public static function login(Request $request) {
        $user = trim($request->post('user', ''));
        $passwd = trim($request->post('passwd', ''));
        if (!$user) {
            return statusFailure('请输入账号');
        }
        if (!$passwd) {
            return statusFailure('请输入密码');
        }
        $systemAdminUser = SystemAdminUser::detail($user);
        if (!$systemAdminUser) {
            return statusFailure('账号错误，请检查');
        }
        if ($systemAdminUser->passwd != md5($passwd)) {
            return statusFailure('密码错误，请检查');
        }
        if (!Auth::refresh('admin', (array) $systemAdminUser->attribute)) {
            return statusFailure('登录失败，请重试');
        }
        return statusSuccess('登录成功');
    }

    /**
     * password
     * @param Request $request
     * @param type $adminUser
     * @return type
     */
    public static function password(Request $request, $adminUser) {
        $password1 = trim($request->post('password1', ''));
        $password2 = trim($request->post('password2', ''));
        $password3 = trim($request->post('password3', ''));
        if (!$password1) {
            return statusFailure('请输入旧密码');
        }
        if (!$password2) {
            return statusFailure('请输入新密码');
        }
        if (!$password3) {
            return statusFailure('请再次输入新密码');
        }
        if ($adminUser->passwd != md5($password1)) {
            return statusFailure('旧密码错误，请检查');
        }
        if ($password2 != $password3) {
            return statusFailure('两次输入的新密码不一致，请检查');
        }
        $adminUser->passwd = md5($password2);
        if (!$adminUser->save()) {
            return statusFailure('修改密码失败，请重试');
        }
        Auth::remove('admin');
        return statusSuccess('修改密码成功');
    }

    /**
     * detail
     * @param type $user
     * @return type
     */
    public static function detail($user) {
        return SystemAdminUser::first("select * from {table} where user='$user' and status in (1,2);");
    }

}
