<?php

namespace shangfan\model\base;

use framework\Request;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * SystemCity
 */
class SystemCity extends BaseModel {

    public $table = 'shangfan_system_city';
    public $key = 'id';

    /**
     * listsProvince
     * @return type
     */
    public static function listsProvince() {
        return SystemCity::get("select * from {table} where is_show=1 and pid=0 order by sort asc,id asc;");
    }

    /**
     * ajaxCity
     * @param type $pid
     * @return type
     */
    public static function ajaxCity($pid) {
        $systemCity = SystemCity::get("select * from {table} where is_show=1 and pid={$pid} order by sort asc,id asc;");
        if (!count($systemCity)) {
            return statusSuccess('', []);
        }
        $data = [];
        foreach ($systemCity as $val) {
            $data[] = [
                'id' => $val->id,
                'name' => $val->name,
            ];
        }
        return statusSuccess('', ['item' => $data]);
    }

    /**
     * detail
     * @param type $cityId
     * @return type
     */
    public static function detail($cityId) {
        return SystemCity::first("select * from {table} where id={$cityId};");
    }

    /**
     * strCityName
     * @param type $cityId
     * @return string
     */
    public static function strCityName($cityId) {
        $detail = SystemCity::detail($cityId);
        if (!$detail) {
            return '-';
        }
        return $detail->name;
    }

    /**
     * cityNameToId
     * @param Request $request
     * @return type
     */
    public static function cityNameToId(Request $request) {
        $cityName = $request->param('cityName', '');
        if (!$cityName) {
            return statusFailure('请选择城市');
        }
        $cityNameArr = explode(',', $cityName);
        if (count($cityNameArr) != 3) {
            return statusFailure('请选择城市');
        }
        $provinceId = 0;
        $cityId = 0;
        $countyId = 0;
        $systemCity = SystemCity::first("select id from {table} where is_show=1 and name='{$cityNameArr[0]}';");
        if ($systemCity) {
            $provinceId = $systemCity->id;
        }
        $systemCity = SystemCity::first("select id from {table} where is_show=1 and name='{$cityNameArr[1]}';");
        if ($systemCity) {
            $cityId = $systemCity->id;
        }
        $systemCity = SystemCity::first("select id from {table} where is_show=1 and name='{$cityNameArr[2]}';");
        if ($systemCity) {
            $countyId = $systemCity->id;
        }
        return statusSuccess('', ['provinceId' => $provinceId, 'cityId' => $cityId, 'countyId' => $countyId]);
    }

}
