<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\SystemAdminUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 焦点图管理
 */
class SystemFocus extends BaseModel {

    public $table = 'shangfan_system_focus';
    public $key = 'id';

    /**
     * pcAddStep1
     * @param Request $request
     * @return type
     */
    public static function pcAddStep1(Request $request) {
        if (!$request->post('name', '')) {
            return statusFailure('请输入焦点图名称');
        }
        $insert = [
            'name' => $request->post('name', ''),
            'url' => $request->post('url', ''),
            'sort' => intval($request->post('sort', 0)),
            'create_time' => time(),
            'type' => 1,
            'status' => 2
        ];
        $focusId = SystemFocus::insert($insert);
        if (!$focusId) {
            return statusFailure('添加焦点图失败，请重试');
        }
        return statusSuccess('', ['focusId' => $focusId]);
    }

    /**
     * pcEditStep1
     * @param Request $request
     * @return type
     */
    public static function pcEditStep1(Request $request, $focusId) {
        if (!$request->post('name', '')) {
            return statusFailure('请输入焦点图名称');
        }
        $systemFocus = SystemFocus::detail($focusId);
        if (!$systemFocus) {
            return statusFailure('未找到数据');
        }
        $systemFocus->fill([
            'name' => $request->post('name', ''),
            'url' => $request->post('url', ''),
            'sort' => intval($request->post('sort', 0)),
            'create_time' => time(),
        ]);
        if (!$systemFocus->save()) {
            return statusFailure('修改焦点图失败，请重试');
        }
        return statusSuccess('修改焦点图成功', ['focusId' => $focusId]);
    }

    /**
     * pcOnline
     * @param type $focusId
     * @return type
     */
    public static function pcOnline($focusId) {
        $systemFocus = SystemFocus::detail($focusId);
        if (!$systemFocus) {
            return statusFailure('未找到数据');
        }
        if ($systemFocus->status == 1) {
            return statusSuccess('上架焦点图成功');
        }
        $systemFocus->status = 1;
        if (!$systemFocus->save()) {
            return statusFailure('上架焦点图失败，请重试');
        }
        return statusSuccess('上架焦点图成功');
    }

    /**
     * pcOffline
     * @param type $focusId
     * @return type
     */
    public static function pcOffline($focusId) {
        $systemFocus = SystemFocus::detail($focusId);
        if (!$systemFocus) {
            return statusFailure('未找到数据');
        }
        $systemFocus->status = 2;
        if (!$systemFocus->save()) {
            return statusFailure('下架焦点图失败，请重试');
        }
        return statusSuccess('下架焦点图成功');
    }

    /**
     * pcDel
     * @param type $focusId
     * @return type
     */
    public static function pcDel($focusId) {
        $systemFocus = SystemFocus::detail($focusId);
        if (!$systemFocus) {
            return statusFailure('未找到数据');
        }
        $unlinkPicSrc = rootPath() . '/public' . $systemFocus->pic;
        if (file_exists($unlinkPicSrc)) {
            @unlink($unlinkPicSrc);
        }
        $systemFocus->status = 0;
        if (!$systemFocus->save()) {
            return statusFailure('删除焦点图失败，请重试');
        }
        return statusSuccess('删除焦点图成功');
    }

    /**
     * updateFocusPic
     * @param SystemAdminUser $systemAdminUser
     * @param type $focusId
     * @param type $picSrc
     * @return boolean
     */
    public static function updateFocusPic(SystemAdminUser $systemAdminUser, $focusId, $picSrc) {
        if (!$systemAdminUser || !$focusId || !$picSrc) {
            return false;
        }
        $systemFocus = SystemFocus::detail($focusId);
        if (!$systemFocus) {
            return false;
        }
        $unlinkPicSrc = rootPath() . '/public' . $systemFocus->pic;
        if (file_exists($unlinkPicSrc)) {
            @unlink($unlinkPicSrc);
        }
        $systemFocus->fill([
            'pic' => $picSrc,
            'admin_user_id' => $systemAdminUser->id,
        ]);
        return $systemFocus->save();
    }

    /**
     * pcLists
     * @return type
     */
    public static function pcLists(Request $request) {
        $results = SystemFocus::get("select * from {table} where type=1 and status in (1,2) order by sort asc,id asc;");
        if (!count($results)) {
            return [];
        }
        foreach ($results as &$val) {
            $val->strStatus = SystemFocus::strStatus($val->status);
        }
        return $results;
    }

    /**
     * h5Lists
     * @return type
     */
    public static function h5Lists(Request $request) {
        $results = SystemFocus::get("select * from {table} where type=2 and status in (1,2) order by sort asc,id asc;");
        if (!count($results)) {
            return [];
        }
        foreach ($results as &$val) {
            $val->strStatus = SystemFocus::strStatus($val->status);
        }
        return $results;
    }
    
    /**
     * h5AddStep1
     * @param Request $request
     * @return type
     */
    public static function h5AddStep1(Request $request) {
        if (!$request->post('name', '')) {
            return statusFailure('请输入焦点图名称');
        }
        $insert = [
            'name' => $request->post('name', ''),
            'url' => $request->post('url', ''),
            'sort' => intval($request->post('sort', 0)),
            'create_time' => time(),
            'type' => 2,
            'status' => 2
        ];
        $focusId = SystemFocus::insert($insert);
        if (!$focusId) {
            return statusFailure('添加焦点图失败，请重试');
        }
        return statusSuccess('', ['focusId' => $focusId]);
    }
    
    /**
     * h5EditStep1
     * @param Request $request
     * @return type
     */
    public static function h5EditStep1(Request $request, $focusId) {
        return SystemFocus::pcEditStep1($request, $focusId);
    }
    
    /**
     * h5Online
     * @param type $focusId
     * @return type
     */
    public static function h5Online($focusId) {
        return SystemFocus::pcOnline($focusId);
    }

    /**
     * h5Offline
     * @param type $focusId
     * @return type
     */
    public static function h5Offline($focusId) {
        return SystemFocus::pcOffline($focusId);
    }

    /**
     * h5Del
     * @param type $focusId
     * @return type
     */
    public static function h5Del($focusId) {
        return SystemFocus::pcDel($focusId);
    }

    /**
     * strStatus
     * @param type $status
     * @return string
     */
    public static function strStatus($status) {
        if ($status == 1) {
            return '上架展示';
        }
        if ($status == 2) {
            return '等待上架';
        }
        if ($status == 0) {
            return '已删除';
        }
        return '-';
    }

    /**
     * detail
     * @param type $focusId
     * @return type
     */
    public static function detail($focusId) {
        return SystemFocus::first("select * from {table} where id={$focusId};");
    }

}
