<?php

namespace shangfan\model\base;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * SystemPayNotify
 */
class SystemPayNotify extends BaseModel {

    public $table = 'shangfan_system_pay_notify';
    public $key = 'id';

    /**
     * add
     * @param type $conf
     * @param type $result
     * @param type $type 1wechat 2alipay
     */
    public static function add($result, $type = 'alipay') {
        $insert = [
            'type' => 0,
            'response' => json_encode($result) ? json_encode($result) : json_encode([]),
            'create_time' => time()
        ];
        if ($type == 'wechat') {
            $insert['type'] = 1;
        }
        if ($type == 'alipay') {
            $insert['type'] = 2;
        }
        $success = SystemPayNotify::insert($insert);
        if (!$success) {
            return statusFailure();
        }
        return statusSuccess();
    }

}
