layui.use(['jquery', 'layer'], function () {
    $ = layui.$;
    var layer = layui.layer;
    navbarItem(2);
    layoutInit();
    categoryInit();
});
function categoryInit() {
    var $eveCategoryId = document.getElementsByClassName('eveCategoryId');
    if (!$eveCategoryId.length) {
        return;
    }
    var $categoryId = 0;
    if ($eveCategoryId[0]) {
        $categoryId = parseInt($eveCategoryId[0].getAttribute('categoryId'));
    }
    if (!$categoryId) {
        return;
    }
    categoryLevel3Ajax($eveCategoryId[0], $categoryId);
}
function categoryLevel3Ajax($this, $categoryId) {
    var $eveCategoryId = document.getElementsByClassName('eveCategoryId');
    if ($eveCategoryId.length) {
        for (var $i = 0; $i <= $eveCategoryId.length; $i++) {
            if ($eveCategoryId[$i]) {
                $eveCategoryId[$i].classList.remove('active');
            }
        }
    }
    $this.classList.add('active');
    $.post('/h5/mall/category/ajax/category/level3/' + $categoryId, {}, function ($data) {
        document.getElementById('right').innerHTML = $data;
    });
}
function layoutInit() {
    $scrollHeight = document.body.scrollHeight;
    $scrollWidth = document.body.scrollWidth;
    var $topBottomHeight = 50 + 45;
    var $leftHeight = 80;
    var $left = document.getElementById('left');
    if ($left) {
        $left.style.width = $leftHeight + 'px';
        $left.style.minHeight = ($scrollHeight - $topBottomHeight) + 'px';
    }
    $right = document.getElementById('right');
    if ($right) {
        $right.style.width = ($scrollWidth - $leftHeight) + 'px';
        $right.style.minHeight = ($scrollHeight - $topBottomHeight) + 'px';
    }
    $category = document.getElementById('category');
    if ($category) {
        $category.style.display = 'inline';
    }
}